/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.boot.ui;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.debug.ui.launchConfigurations.JavaApplicationLaunchShortcut;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.internal.debug.ui.launcher.LauncherMessages;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.springsource.ide.eclipse.commons.frameworks.core.ExceptionUtil;
import org.springsource.ide.eclipse.commons.frameworks.core.maintype.MainTypeFinder;

public class BootLaunchShortcut
extends JavaApplicationLaunchShortcut {
    public static final String LAUNCH_CONFIG_TYPE_ID = IJavaLaunchConfigurationConstants.ID_JAVA_APPLICATION;
    public static final String JMX_PORT_PROP = "com.sun.management.jmxremote.port";

    public static String liveBeanVmArgs(int jmxPort) {
        return BootLaunchShortcut.liveBeanVmArgs("" + jmxPort);
    }

    public static String liveBeanVmArgs(String jmxPort) {
        return "-Dspring.liveBeansView.mbeanDomain\n-Dcom.sun.management.jmxremote\n-Dcom.sun.management.jmxremote.port=" + jmxPort + "\n" + "-Dcom.sun.management.jmxremote.authenticate=false\n" + "-Dcom.sun.management.jmxremote.ssl=false\n";
    }

    protected IType[] findTypes(Object[] elements, IRunnableContext context) throws InterruptedException, CoreException {
        Object[] objectArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            Object e = objectArray[n2];
            if (e instanceof IProject) {
                try {
                    e = JavaCore.create((IProject)((IProject)e));
                }
                catch (Throwable throwable) {}
            }
            if (e instanceof IJavaElement) {
                final IJavaProject jp = ((IJavaElement)e).getJavaProject();
                final IType[][] result = new IType[1][];
                try {
                    context.run(false, false, new IRunnableWithProgress(){

                        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                            try {
                                result[0] = MainTypeFinder.guessMainTypes((IJavaProject)jp, (IProgressMonitor)monitor);
                            }
                            catch (CoreException e) {
                                throw new InvocationTargetException(e);
                            }
                        }
                    });
                }
                catch (InvocationTargetException exception) {
                    throw ExceptionUtil.coreException((Throwable)exception);
                }
                return result[0];
            }
            ++n2;
        }
        return super.findTypes(elements, context);
    }

    protected ILaunchConfigurationType getConfigurationType() {
        return this.getLaunchManager().getLaunchConfigurationType(LAUNCH_CONFIG_TYPE_ID);
    }

    protected ILaunchConfiguration createConfiguration(IType type) {
        ILaunchConfiguration config = null;
        ILaunchConfigurationWorkingCopy wc = null;
        try {
            int jmxPort = (int)(5000.0 + Math.random() * 60000.0);
            ILaunchConfigurationType configType = this.getConfigurationType();
            String projectName = type.getJavaProject().getElementName();
            wc = configType.newInstance(null, String.valueOf(projectName) + " - " + this.getLaunchManager().generateLaunchConfigurationName(type.getTypeQualifiedName('.')));
            wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_MAIN_TYPE_NAME, type.getFullyQualifiedName());
            wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, projectName);
            wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_ARGUMENTS, BootLaunchShortcut.liveBeanVmArgs(jmxPort));
            wc.setMappedResources(new IResource[]{type.getUnderlyingResource()});
            config = wc.doSave();
        }
        catch (CoreException exception) {
            MessageDialog.openError((Shell)JDIDebugUIPlugin.getActiveWorkbenchShell(), (String)LauncherMessages.JavaLaunchShortcut_3, (String)exception.getStatus().getMessage());
        }
        return config;
    }

    private ILaunchManager getLaunchManager() {
        return DebugPlugin.getDefault().getLaunchManager();
    }

    public static void launch(IProject project, String mode) {
        BootLaunchShortcut shortcut = new BootLaunchShortcut();
        StructuredSelection selection = new StructuredSelection(new Object[]{project});
        shortcut.launch((ISelection)selection, mode);
    }
}

