/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.util;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.io.Resources;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.CheckForNull;

public class VersionUtils {
    private static final String VERSION_REGEX = ".*?(\\d+\\.\\d+(?:\\.\\d+)*).*";
    private static final Pattern JAR_VERSION_PATTERN = Pattern.compile(".*?(\\d+\\.\\d+(?:\\.\\d+)*).*");

    private VersionUtils() {
    }

    public static String getLibraryVersion() {
        Package packageInfo = VersionUtils.class.getPackage();
        String version = packageInfo != null && packageInfo.getImplementationVersion() != null ? packageInfo.getImplementationVersion() : VersionUtils.getLibraryVersionFallback();
        return version;
    }

    @VisibleForTesting
    static String getLibraryVersionFallback() {
        String version = "unknown";
        URL resource = VersionUtils.class.getResource("/sl_core_version.txt");
        if (resource != null) {
            try {
                version = Resources.toString(resource, StandardCharsets.UTF_8);
            }
            catch (IOException e) {
                return version;
            }
        }
        return version;
    }

    @CheckForNull
    public static String getJarVersion(String jarName) {
        Matcher matcher = JAR_VERSION_PATTERN.matcher(jarName);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return null;
    }
}

