/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.util;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.annotation.Nullable;

public class StringUtils {
    private StringUtils() {
    }

    public static String urlEncode(String toEncode) {
        try {
            return URLEncoder.encode(toEncode, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("Should never happen", e);
        }
    }

    public static String describe(Object o) {
        try {
            String str;
            if (o.getClass().getMethod("toString", new Class[0]).getDeclaringClass() != Object.class && (str = o.toString()) != null) {
                return str;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return o.getClass().getName();
    }

    public static boolean isEmpty(@Nullable String str) {
        return str == null || str.isEmpty();
    }

    public static String md5(String s) {
        try {
            return StringUtils.md5(new ByteArrayInputStream(s.getBytes(StandardCharsets.UTF_8)));
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public static String md5(InputStream data) throws IOException {
        MessageDigest md;
        try {
            md = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException(e);
        }
        int bufLen = 8192;
        byte[] buffer = new byte[bufLen];
        int read = data.read(buffer, 0, bufLen);
        while (read > -1) {
            md.update(buffer, 0, read);
            read = data.read(buffer, 0, bufLen);
        }
        byte[] array = md.digest();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < array.length; ++i) {
            sb.append(Integer.toHexString(array[i] & 0xFF | 0x100).substring(1, 3));
        }
        return sb.toString();
    }
}

