/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.util;

import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.stream.StreamSupport;
import org.sonarsource.sonarlint.core.client.api.common.analysis.ClientInputFile;

public class LoggedErrorHandler {
    private static final String PARSING_ERROR_PREFIX = "Unable to parse source file : ";
    private static final String PARSING_ERROR_PREFIX_JS = "Unable to parse file: ";
    private final Set<ClientInputFile> erroredFiles;
    private final Iterable<ClientInputFile> inputFiles;

    public LoggedErrorHandler(Iterable<ClientInputFile> inputFiles) {
        this.inputFiles = inputFiles;
        this.erroredFiles = new HashSet<ClientInputFile>();
    }

    public void handleException(String className) {
        if (className.equals(IllegalStateException.class.getName())) {
            for (ClientInputFile file : this.inputFiles) {
                this.erroredFiles.add(file);
            }
        }
    }

    public void handleError(String msg) {
        if (msg.startsWith(PARSING_ERROR_PREFIX)) {
            this.markFileError(msg.substring(PARSING_ERROR_PREFIX.length()));
        } else if (msg.startsWith(PARSING_ERROR_PREFIX_JS)) {
            this.markFileError(msg.substring(PARSING_ERROR_PREFIX_JS.length()));
        }
    }

    private void markFileError(String absoluteFilePath) {
        Optional<ClientInputFile> matched = StreamSupport.stream(this.inputFiles.spliterator(), false).filter(f -> f.getPath().equals(absoluteFilePath)).findAny();
        if (matched.isPresent()) {
            this.erroredFiles.add(matched.get());
        }
    }

    public Set<ClientInputFile> getErrorFiles() {
        return this.erroredFiles;
    }
}

