/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.tracking;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.sonarsource.sonarlint.core.proto.Sonarlint;
import org.sonarsource.sonarlint.core.tracking.StoreIndex;

class StringStoreIndex
implements StoreIndex<String> {
    private static final String DEFAULT_INDEX_FILENAME = "index.pb";
    private final Path storeBasePath;
    private final Path indexFilePath;

    public StringStoreIndex(Path storeBasePath) {
        this(storeBasePath, DEFAULT_INDEX_FILENAME);
    }

    protected StringStoreIndex(Path storeBasePath, String indexFileName) {
        this.storeBasePath = storeBasePath;
        this.indexFilePath = storeBasePath.resolve(indexFileName);
    }

    @Override
    public Collection<String> keys() {
        return this.load().keySet();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Map<String, String> load() {
        if (!this.indexFilePath.toFile().exists()) {
            return Collections.emptyMap();
        }
        try (InputStream stream = Files.newInputStream(this.indexFilePath, new OpenOption[0]);){
            Map<String, String> map = Sonarlint.StorageIndex.parseFrom(stream).getMappedPathByKeyMap();
            return map;
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to read local issue store index", e);
        }
    }

    @Override
    public void save(String storageKey, Path path) {
        String relativeMappedPath = this.storeBasePath.relativize(path).toString();
        Sonarlint.StorageIndex.Builder builder = Sonarlint.StorageIndex.newBuilder();
        builder.putAllMappedPathByKey(this.load());
        builder.putMappedPathByKey(storageKey, relativeMappedPath);
        this.save(builder.build());
    }

    @Override
    public void delete(String storageKey) {
        Sonarlint.StorageIndex.Builder builder = Sonarlint.StorageIndex.newBuilder();
        builder.putAllMappedPathByKey(this.load());
        builder.removeMappedPathByKey(storageKey);
        this.save(builder.build());
    }

    private void save(Sonarlint.StorageIndex index) {
        try (OutputStream stream = Files.newOutputStream(this.indexFilePath, new OpenOption[0]);){
            index.writeTo(stream);
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to write local issue store index", e);
        }
    }
}

