/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.tracking;

import java.util.ArrayList;
import java.util.Collection;
import org.sonarsource.sonarlint.core.tracking.CombinedTrackable;
import org.sonarsource.sonarlint.core.tracking.DisconnectedTrackable;
import org.sonarsource.sonarlint.core.tracking.IssueTracker;
import org.sonarsource.sonarlint.core.tracking.LeakedTrackable;
import org.sonarsource.sonarlint.core.tracking.Trackable;
import org.sonarsource.sonarlint.core.tracking.Tracker;
import org.sonarsource.sonarlint.core.tracking.Tracking;

public class IssueTrackerImpl
implements IssueTracker {
    @Override
    public Collection<Trackable> apply(Collection<Trackable> baseIssues, Collection<Trackable> nextIssues, boolean inheritSeverity) {
        ArrayList<Trackable> trackedIssues = new ArrayList<Trackable>();
        Tracking tracking = new Tracker().track(() -> nextIssues, () -> baseIssues);
        tracking.getMatchedRaws().entrySet().stream().map(e -> new CombinedTrackable((Trackable)e.getValue(), (Trackable)e.getKey(), inheritSeverity)).forEach(trackedIssues::add);
        for (Trackable next : tracking.getUnmatchedRaws()) {
            if (next.getServerIssueKey() != null) {
                next = new DisconnectedTrackable(next);
            } else if (next.getCreationDate() == null) {
                next = new LeakedTrackable(next);
            }
            trackedIssues.add(next);
        }
        return trackedIssues;
    }
}

