/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.tracking;

import javax.annotation.Nullable;
import org.sonarsource.sonarlint.core.client.api.common.analysis.Issue;
import org.sonarsource.sonarlint.core.tracking.DigestUtils;
import org.sonarsource.sonarlint.core.tracking.TextRange;
import org.sonarsource.sonarlint.core.tracking.Trackable;

public class IssueTrackable
implements Trackable {
    private final Issue issue;
    private final TextRange textRange;
    private final Integer textRangeHash;
    private final Integer lineHash;

    public IssueTrackable(Issue issue) {
        this(issue, null, null, null);
    }

    public IssueTrackable(Issue issue, @Nullable TextRange textRange, @Nullable String textRangeContent, @Nullable String lineContent) {
        this.issue = issue;
        this.textRange = textRange;
        this.textRangeHash = IssueTrackable.hashOrNull(textRangeContent);
        this.lineHash = IssueTrackable.hashOrNull(lineContent);
    }

    private static Integer hashOrNull(@Nullable String content) {
        return content != null ? Integer.valueOf(DigestUtils.digest(content).hashCode()) : null;
    }

    @Override
    public Issue getIssue() {
        return this.issue;
    }

    @Override
    public String getRuleKey() {
        return this.issue.getRuleKey();
    }

    @Override
    public String getRuleName() {
        return this.issue.getRuleName();
    }

    @Override
    public String getSeverity() {
        return this.issue.getSeverity();
    }

    @Override
    public String getType() {
        return this.issue.getType();
    }

    @Override
    public String getMessage() {
        return this.issue.getMessage();
    }

    @Override
    public Integer getLine() {
        return this.issue.getStartLine();
    }

    @Override
    public Integer getLineHash() {
        return this.lineHash;
    }

    @Override
    public TextRange getTextRange() {
        return this.textRange;
    }

    @Override
    public Integer getTextRangeHash() {
        return this.textRangeHash;
    }

    @Override
    public Long getCreationDate() {
        return null;
    }

    @Override
    public String getServerIssueKey() {
        return null;
    }

    @Override
    public boolean isResolved() {
        return false;
    }

    @Override
    public String getAssignee() {
        return "";
    }
}

