/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.tracking;

import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class DigestUtils {
    private static final char[] DIGITS = "0123456789abcdef".toCharArray();
    private static final MessageDigest MD5_DIGEST = DigestUtils.getMd5Digest();

    private DigestUtils() {
    }

    public static String digest(String content) {
        return DigestUtils.encodeHexString(MD5_DIGEST.digest(content.replaceAll("[\\s]", "").getBytes(StandardCharsets.UTF_8)));
    }

    private static MessageDigest getMd5Digest() {
        return DigestUtils.getDigest("MD5");
    }

    private static MessageDigest getDigest(String algorithm) {
        try {
            return MessageDigest.getInstance(algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private static String encodeHexString(byte[] data) {
        int length = data.length;
        char[] out = new char[length << 1];
        int i = 0;
        int j = 0;
        while (i < length) {
            out[j] = DIGITS[(0xF0 & data[i]) >>> 4];
            out[j + 1] = DIGITS[0xF & data[i]];
            ++i;
            j += 2;
        }
        return new String(out);
    }
}

