/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.telemetry;

import com.google.gson.Gson;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Base64;
import org.sonarsource.sonarlint.core.telemetry.TelemetryData;

class TelemetryStorage {
    private final Path path;

    TelemetryStorage(Path path) {
        this.path = path;
    }

    private void save(TelemetryData data) throws IOException {
        Files.createDirectories(this.path.getParent(), new FileAttribute[0]);
        Gson gson = new Gson();
        String json = gson.toJson(data);
        byte[] encoded = Base64.getEncoder().encode(json.getBytes(StandardCharsets.UTF_8));
        Files.write(this.path, encoded, new OpenOption[0]);
    }

    void trySave(TelemetryData data) {
        try {
            this.save(data);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private TelemetryData load() throws IOException {
        Gson gson = new Gson();
        byte[] bytes = Files.readAllBytes(this.path);
        byte[] decoded = Base64.getDecoder().decode(bytes);
        String json = new String(decoded, StandardCharsets.UTF_8);
        return TelemetryData.validate(gson.fromJson(json, TelemetryData.class));
    }

    TelemetryData tryLoad() {
        try {
            return this.load();
        }
        catch (Exception e) {
            return new TelemetryData();
        }
    }
}

