/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.telemetry;

import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonarsource.sonarlint.core.client.api.common.SonarLintPathManager;
import org.sonarsource.sonarlint.core.client.api.util.SonarLintUtils;

public class TelemetryPathManager {
    private static final Logger LOG = Loggers.get(TelemetryPathManager.class);

    private TelemetryPathManager() {
    }

    public static Path getPath(String productKey) {
        return SonarLintPathManager.home().resolve("telemetry").resolve(productKey).resolve("usage");
    }

    public static void migrate(String productKey, Path oldPath) {
        block4: {
            Path newPath = TelemetryPathManager.getPath(productKey);
            if (newPath.toFile().isFile() || !oldPath.toFile().exists()) {
                return;
            }
            try {
                if (!newPath.getParent().toFile().exists()) {
                    Files.createDirectories(newPath.getParent(), new FileAttribute[0]);
                }
                Files.copy(oldPath, newPath, new CopyOption[0]);
            }
            catch (IOException e) {
                if (!SonarLintUtils.isInternalDebugEnabled()) break block4;
                LOG.error("Failed to migrate telemetry storage", e);
            }
        }
    }
}

