/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.telemetry;

import com.google.common.annotations.VisibleForTesting;
import java.nio.file.Path;
import java.time.LocalDate;
import org.sonarsource.sonarlint.core.telemetry.TelemetryClient;
import org.sonarsource.sonarlint.core.telemetry.TelemetryData;
import org.sonarsource.sonarlint.core.telemetry.TelemetryStorage;
import org.sonarsource.sonarlint.core.telemetry.TelemetryUtils;

public class TelemetryManager {
    public static final String TELEMETRY_ENDPOINT = "https://chestnutsl.sonarsource.com";
    static final int MIN_HOURS_BETWEEN_UPLOAD = 5;
    private final TelemetryStorage storage;
    private final TelemetryData data;
    private final TelemetryClient client;
    private LocalDate lastSavedDate;

    public TelemetryManager(Path path, TelemetryClient client) {
        this.storage = this.newTelemetryStorage(path);
        this.data = this.storage.tryLoad();
        this.client = client;
    }

    @VisibleForTesting
    TelemetryStorage newTelemetryStorage(Path path) {
        return new TelemetryStorage(path);
    }

    public boolean isEnabled() {
        return this.data.enabled();
    }

    public void enable() {
        this.tryMerge();
        this.data.setEnabled(true);
        this.saveNow();
        this.uploadLazily();
    }

    public void disable() {
        this.tryMerge();
        this.data.setEnabled(false);
        this.saveNow();
        this.client.optOut(this.data);
    }

    private void tryMerge() {
        TelemetryData existing = this.storage.tryLoad();
        if (existing != null) {
            this.data.mergeFrom(existing);
        }
    }

    public void uploadLazily() {
        if (!TelemetryUtils.dayChanged(this.data.lastUploadTime(), 5L)) {
            return;
        }
        this.tryMerge();
        if (!TelemetryUtils.dayChanged(this.data.lastUploadTime(), 5L)) {
            return;
        }
        this.data.setLastUploadTime();
        this.saveNow();
        this.client.upload(this.data);
    }

    public void usedAnalysis() {
        this.data.setUsedAnalysis();
        this.saveLazily();
    }

    public void usedConnectedMode(boolean hasConnectedProject) {
        this.data.setUsedConnectedMode(hasConnectedProject);
        this.saveLazily();
    }

    public void stop() {
        this.saveLazily();
        this.uploadLazily();
    }

    private void saveLazily() {
        if (!TelemetryUtils.dayChanged(this.lastSavedDate)) {
            return;
        }
        this.tryMerge();
        this.saveNow();
    }

    private void saveNow() {
        this.lastSavedDate = LocalDate.now();
        this.storage.trySave(this.data);
    }
}

