/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.telemetry;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;

class TelemetryData {
    private LocalDate installDate = LocalDate.now();
    private LocalDate lastUseDate;
    private LocalDateTime lastUploadDateTime;
    private long numUseDays;
    private boolean enabled = true;
    private boolean usedConnectedMode;

    TelemetryData() {
    }

    void setInstallDate(LocalDate date) {
        this.installDate = date;
    }

    LocalDate installDate() {
        return this.installDate;
    }

    void setLastUseDate(@Nullable LocalDate date) {
        this.lastUseDate = date;
    }

    @CheckForNull
    LocalDate lastUseDate() {
        return this.lastUseDate;
    }

    void setLastUploadTime() {
        this.setLastUploadTime(LocalDateTime.now());
    }

    void setLastUploadTime(@Nullable LocalDateTime dateTime) {
        this.lastUploadDateTime = dateTime;
    }

    @CheckForNull
    LocalDateTime lastUploadTime() {
        return this.lastUploadDateTime;
    }

    void setNumUseDays(long numUseDays) {
        this.numUseDays = numUseDays;
    }

    long numUseDays() {
        return this.numUseDays;
    }

    void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    boolean enabled() {
        return this.enabled;
    }

    void setUsedConnectedMode(boolean value) {
        this.usedConnectedMode = value;
    }

    boolean usedConnectedMode() {
        return this.usedConnectedMode;
    }

    void setUsedAnalysis() {
        LocalDate now = LocalDate.now();
        if (this.lastUseDate == null || !this.lastUseDate.equals(now)) {
            ++this.numUseDays;
        }
        this.lastUseDate = now;
    }

    void mergeFrom(TelemetryData other) {
        if (other.usedConnectedMode) {
            this.usedConnectedMode = true;
        }
        if (TelemetryData.isOlder(this.lastUseDate, other.lastUseDate)) {
            this.lastUseDate = other.lastUseDate;
        }
        if (other.numUseDays > this.numUseDays) {
            this.numUseDays = other.numUseDays;
            this.installDate = other.installDate;
        }
        if (TelemetryData.isOlder(this.lastUploadDateTime, other.lastUploadDateTime)) {
            this.lastUploadDateTime = other.lastUploadDateTime;
        }
    }

    static boolean isOlder(@Nullable LocalDate first, @Nullable LocalDate second) {
        return first == null || second != null && first.isBefore(second);
    }

    static boolean isOlder(@Nullable LocalDateTime first, @Nullable LocalDateTime second) {
        return first == null || second != null && first.isBefore(second);
    }

    static TelemetryData validate(TelemetryData data) {
        LocalDate lastUseDate;
        LocalDate today = LocalDate.now();
        if (data.installDate() == null || data.installDate().isAfter(today)) {
            data.setInstallDate(today);
        }
        if ((lastUseDate = data.lastUseDate()) == null) {
            data.setNumUseDays(0L);
            return data;
        }
        if (lastUseDate.isBefore(data.installDate())) {
            data.setLastUseDate(data.installDate());
        } else if (lastUseDate.isAfter(today)) {
            data.setLastUseDate(today);
        }
        long maxUseDays = data.installDate().until(data.lastUseDate(), ChronoUnit.DAYS) + 1L;
        if (data.numUseDays() > maxUseDays) {
            data.setNumUseDays(maxUseDays);
            data.setLastUseDate(data.lastUseDate());
        }
        return data;
    }
}

