/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.plugin.cache;

import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.MessageDigest;

public class PluginHashes {
    private static final int STREAM_BUFFER_LENGTH = 1024;

    public String of(Path file) {
        try {
            return this.of(Files.newInputStream(file, new OpenOption[0]));
        }
        catch (IOException e) {
            throw new IllegalStateException("Fail to compute hash of: " + file, e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String of(InputStream input) {
        try (InputStream is = input;){
            MessageDigest digest = MessageDigest.getInstance("MD5");
            byte[] hash = PluginHashes.digest(is, digest);
            String string = PluginHashes.toHex(hash);
            return string;
        }
        catch (Exception e) {
            throw new IllegalStateException("Fail to compute hash", e);
        }
    }

    private static byte[] digest(InputStream input, MessageDigest digest) throws IOException {
        byte[] buffer = new byte[1024];
        int read = input.read(buffer, 0, 1024);
        while (read > -1) {
            digest.update(buffer, 0, read);
            read = input.read(buffer, 0, 1024);
        }
        return digest.digest();
    }

    static String toHex(byte[] bytes) {
        BigInteger bi = new BigInteger(1, bytes);
        return String.format("%0" + (bytes.length << 1) + "x", bi);
    }
}

