/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.plugin;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.picocontainer.Startable;
import org.sonar.api.Plugin;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonarsource.sonarlint.core.client.api.connected.LoadedAnalyzer;
import org.sonarsource.sonarlint.core.container.connected.validate.PluginVersionChecker;
import org.sonarsource.sonarlint.core.container.model.DefaultLoadedAnalyzer;
import org.sonarsource.sonarlint.core.plugin.PluginCacheLoader;
import org.sonarsource.sonarlint.core.plugin.PluginInfo;
import org.sonarsource.sonarlint.core.plugin.PluginLoader;
import org.sonarsource.sonarlint.core.plugin.Version;

public class PluginRepository
implements Startable {
    private static final Logger LOG = Loggers.get(PluginRepository.class);
    private final PluginCacheLoader cacheLoader;
    private final PluginLoader loader;
    private Map<String, Plugin> pluginInstancesByKeys;
    private Map<String, PluginInfo> infosByKeys;
    private PluginVersionChecker pluginVersionChecker;

    public PluginRepository(PluginCacheLoader cacheLoader, PluginLoader loader, PluginVersionChecker pluginVersionChecker) {
        this.cacheLoader = cacheLoader;
        this.loader = loader;
        this.pluginVersionChecker = pluginVersionChecker;
    }

    @Override
    public void start() {
        this.infosByKeys = new HashMap<String, PluginInfo>(this.cacheLoader.load());
        this.pluginInstancesByKeys = new HashMap<String, Plugin>(this.loader.load(this.infosByKeys));
        this.logPlugins();
    }

    private void logPlugins() {
        if (this.infosByKeys.isEmpty()) {
            LOG.debug("No plugins loaded");
        } else {
            LOG.debug("Plugins:");
            for (PluginInfo p : this.infosByKeys.values()) {
                LOG.debug("  * {} {} ({})", p.getName(), p.getVersion(), p.getKey());
            }
        }
    }

    @Override
    public void stop() {
        this.loader.unload(this.pluginInstancesByKeys.values());
        this.pluginInstancesByKeys.clear();
        this.infosByKeys.clear();
    }

    public Collection<LoadedAnalyzer> getLoadedAnalyzers() {
        return this.infosByKeys.values().stream().map(this::pluginInfoToLoadedAnalyzer).collect(Collectors.toList());
    }

    private LoadedAnalyzer pluginInfoToLoadedAnalyzer(PluginInfo p) {
        String version = p.getVersion() != null ? p.getVersion().toString() : null;
        boolean streamSupport = this.supportsStream(p.getKey(), version);
        return new DefaultLoadedAnalyzer(p.getKey(), p.getName(), version, streamSupport);
    }

    private boolean supportsStream(String analyzerKey, @Nullable String version) {
        Version minimalVersion;
        String minVersion = this.pluginVersionChecker.getMinimumStreamSupportVersion(analyzerKey);
        if (version == null || minVersion == null) {
            return false;
        }
        Version v = Version.create(version);
        return v.compareTo(minimalVersion = Version.create(minVersion)) >= 0;
    }

    public Collection<PluginInfo> getPluginInfos() {
        return this.infosByKeys.values();
    }

    public PluginInfo getPluginInfo(String key) {
        PluginInfo info = this.infosByKeys.get(key);
        Preconditions.checkState(info != null, "Plugin [%s] does not exist", key);
        return info;
    }

    public Plugin getPluginInstance(String key) {
        Plugin instance = this.pluginInstancesByKeys.get(key);
        Preconditions.checkState(instance != null, "Plugin [%s] does not exist", key);
        return instance;
    }

    public boolean hasPlugin(String key) {
        return this.infosByKeys.containsKey(key);
    }
}

