/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.plugin;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import java.io.Closeable;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.SystemUtils;
import org.sonar.api.Plugin;
import org.sonar.api.utils.log.Loggers;
import org.sonarsource.sonarlint.core.plugin.ExplodedPlugin;
import org.sonarsource.sonarlint.core.plugin.PluginClassLoaderDef;
import org.sonarsource.sonarlint.core.plugin.PluginClassloaderFactory;
import org.sonarsource.sonarlint.core.plugin.PluginInfo;
import org.sonarsource.sonarlint.core.plugin.PluginJarExploder;

public class PluginLoader {
    private static final String[] DEFAULT_SHARED_RESOURCES = new String[]{"org/sonar/plugins", "com/sonar/plugins", "com/sonarsource/plugins"};
    private final PluginJarExploder jarExploder;
    private final PluginClassloaderFactory classloaderFactory;

    public PluginLoader(PluginJarExploder jarExploder, PluginClassloaderFactory classloaderFactory) {
        this.jarExploder = jarExploder;
        this.classloaderFactory = classloaderFactory;
    }

    public Map<String, Plugin> load(Map<String, PluginInfo> infoByKeys) {
        Collection<PluginClassLoaderDef> defs = this.defineClassloaders(infoByKeys);
        Map<PluginClassLoaderDef, ClassLoader> classloaders = this.classloaderFactory.create(defs);
        return this.instantiatePluginClasses(classloaders);
    }

    @VisibleForTesting
    Collection<PluginClassLoaderDef> defineClassloaders(Map<String, PluginInfo> infoByKeys) {
        HashMap<String, PluginClassLoaderDef> classloadersByBasePlugin = new HashMap<String, PluginClassLoaderDef>();
        for (PluginInfo info : infoByKeys.values()) {
            String baseKey = PluginLoader.basePluginKey(info, infoByKeys);
            PluginClassLoaderDef def = (PluginClassLoaderDef)classloadersByBasePlugin.get(baseKey);
            if (def == null) {
                def = new PluginClassLoaderDef(baseKey);
                classloadersByBasePlugin.put(baseKey, def);
            }
            ExplodedPlugin explodedPlugin = this.jarExploder.explode(info);
            def.addFiles(Arrays.asList(explodedPlugin.getMain()));
            def.addFiles(explodedPlugin.getLibs());
            def.addMainClass(info.getKey(), info.getMainClass());
            for (String defaultSharedResource : DEFAULT_SHARED_RESOURCES) {
                def.getExportMask().addInclusion(String.format("%s/%s/api/", defaultSharedResource, info.getKey()));
            }
            if (!Strings.isNullOrEmpty(info.getBasePlugin())) continue;
            def.setSelfFirstStrategy(info.isUseChildFirstClassLoader());
        }
        return classloadersByBasePlugin.values();
    }

    @VisibleForTesting
    Map<String, Plugin> instantiatePluginClasses(Map<PluginClassLoaderDef, ClassLoader> classloaders) {
        HashMap<String, Plugin> instancesByPluginKey = new HashMap<String, Plugin>();
        for (Map.Entry<PluginClassLoaderDef, ClassLoader> entry : classloaders.entrySet()) {
            PluginClassLoaderDef def = entry.getKey();
            ClassLoader classLoader = entry.getValue();
            for (Map.Entry<String, String> mainClassEntry : def.getMainClassesByPluginKey().entrySet()) {
                String pluginKey = mainClassEntry.getKey();
                String mainClass = mainClassEntry.getValue();
                try {
                    instancesByPluginKey.put(pluginKey, (Plugin)classLoader.loadClass(mainClass).newInstance());
                }
                catch (UnsupportedClassVersionError e) {
                    throw new IllegalStateException(String.format("The plugin [%s] does not support Java %s", pluginKey, SystemUtils.JAVA_VERSION_TRIMMED), e);
                }
                catch (Throwable e) {
                    throw new IllegalStateException(String.format("Fail to instantiate class [%s] of plugin [%s]", mainClass, pluginKey), e);
                }
            }
        }
        return instancesByPluginKey;
    }

    public void unload(Collection<Plugin> plugins) {
        for (Plugin plugin : plugins) {
            ClassLoader classLoader = plugin.getClass().getClassLoader();
            if (!(classLoader instanceof Closeable) || classLoader == this.classloaderFactory.baseClassLoader()) continue;
            try {
                ((Closeable)((Object)classLoader)).close();
            }
            catch (Exception e) {
                Loggers.get(this.getClass()).error("Fail to close classloader " + classLoader.toString(), e);
            }
        }
    }

    static String basePluginKey(PluginInfo plugin, Map<String, PluginInfo> allPluginsPerKey) {
        String base = plugin.getKey();
        String parentKey = plugin.getBasePlugin();
        while (!Strings.isNullOrEmpty(parentKey)) {
            PluginInfo parentPlugin = allPluginsPerKey.get(parentKey);
            base = parentPlugin.getKey();
            parentKey = parentPlugin.getBasePlugin();
        }
        return base;
    }
}

