/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.notifications;

import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TimerTask;
import java.util.function.BinaryOperator;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonarsource.sonarlint.core.client.api.common.NotificationConfiguration;
import org.sonarsource.sonarlint.core.client.api.connected.ServerConfiguration;
import org.sonarsource.sonarlint.core.client.api.notifications.SonarQubeNotification;
import org.sonarsource.sonarlint.core.notifications.NotificationChecker;
import org.sonarsource.sonarlint.core.notifications.NotificationCheckerFactory;

class NotificationTimerTask
extends TimerTask {
    private static final BinaryOperator<ZonedDateTime> MERGE_TIMES = (t1, t2) -> t1.toInstant().compareTo(t2.toInstant()) > 0 ? t1 : t2;
    private static final Logger LOG = LoggerFactory.getLogger(NotificationTimerTask.class);
    private final NotificationCheckerFactory checkerFactory;
    private Collection<NotificationConfiguration> configuredProjects = Collections.emptyList();

    public NotificationTimerTask() {
        this(new NotificationCheckerFactory());
    }

    public NotificationTimerTask(NotificationCheckerFactory checkerFactory) {
        this.checkerFactory = checkerFactory;
    }

    public void setProjects(Collection<NotificationConfiguration> configurations) {
        this.configuredProjects = new ArrayList<NotificationConfiguration>(configurations);
    }

    @Override
    public void run() {
        Map<ServerConfiguration, List<NotificationConfiguration>> mapByServer = this.groupByServer();
        for (Map.Entry<ServerConfiguration, List<NotificationConfiguration>> entry : mapByServer.entrySet()) {
            this.requestForServer(entry.getKey(), entry.getValue());
        }
    }

    private static ZonedDateTime getLastNotificationTime(NotificationConfiguration config) {
        ZonedDateTime oneDayAgo;
        ZonedDateTime lastTime = config.lastNotificationTime().get();
        return lastTime.isAfter(oneDayAgo = ZonedDateTime.now().minusDays(1L)) ? lastTime : oneDayAgo;
    }

    private void requestForServer(ServerConfiguration serverConfiguration, List<NotificationConfiguration> configs) {
        try {
            Map<String, ZonedDateTime> request = configs.stream().collect(Collectors.toMap(NotificationConfiguration::projectKey, NotificationTimerTask::getLastNotificationTime, MERGE_TIMES));
            NotificationChecker notificationChecker = this.checkerFactory.create(serverConfiguration);
            List<SonarQubeNotification> notifications = notificationChecker.request(request);
            for (SonarQubeNotification n : notifications) {
                Stream<Object> matchingConfStream = configs.stream();
                if (n.projectKey() != null) {
                    matchingConfStream = matchingConfStream.filter(c -> c.projectKey().equals(n.projectKey()));
                }
                matchingConfStream.forEach(c -> {
                    c.listener().handle(n);
                    c.lastNotificationTime().set(n.time());
                });
            }
        }
        catch (Exception e) {
            LOG.warn("Failed to request SonarQube events to " + serverConfiguration.getUrl(), e);
        }
    }

    private Map<ServerConfiguration, List<NotificationConfiguration>> groupByServer() {
        return this.configuredProjects.stream().collect(Collectors.groupingBy(NotificationConfiguration::serverConfiguration));
    }
}

