/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.notifications;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.CheckForNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonarsource.sonarlint.core.client.api.notifications.SonarQubeNotification;
import org.sonarsource.sonarlint.core.container.connected.SonarLintWsClient;
import org.sonarsource.sonarlint.core.container.model.DefaultSonarQubeNotification;
import org.sonarsource.sonarlint.core.util.StringUtils;
import org.sonarsource.sonarlint.core.util.ws.WsResponse;

class NotificationChecker {
    private static final Logger LOG = LoggerFactory.getLogger(NotificationChecker.class);
    private static final String API_PATH = "api/developers/search_events";
    private static final DateTimeFormatter TIME_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ssZ");
    private final SonarLintWsClient wsClient;

    NotificationChecker(SonarLintWsClient wsClient) {
        this.wsClient = wsClient;
    }

    @CheckForNull
    public List<SonarQubeNotification> request(Map<String, ZonedDateTime> projectTimestamps) {
        String path = NotificationChecker.getWsPath(projectTimestamps);
        WsResponse wsResponse = this.wsClient.rawGet(path);
        if (!wsResponse.isSuccessful()) {
            LOG.debug("Failed to get notifications: {}, {}", (Object)wsResponse.code(), (Object)wsResponse.content());
            return Collections.emptyList();
        }
        return NotificationChecker.parseResponse(wsResponse.content());
    }

    public boolean isSupported() {
        String path = NotificationChecker.getWsPath(Collections.emptyMap());
        WsResponse wsResponse = this.wsClient.rawGet(path);
        return wsResponse.isSuccessful();
    }

    private static String getWsPath(Map<String, ZonedDateTime> projectTimestamps) {
        StringBuilder builder = new StringBuilder();
        builder.append(API_PATH);
        builder.append("?projects=");
        builder.append(projectTimestamps.keySet().stream().map(StringUtils::urlEncode).collect(Collectors.joining(",")));
        builder.append("&from=");
        builder.append(projectTimestamps.values().stream().map(timestamp -> timestamp.format(TIME_FORMATTER)).map(StringUtils::urlEncode).collect(Collectors.joining(",")));
        return builder.toString();
    }

    private static List<SonarQubeNotification> parseResponse(String contents) {
        ArrayList<SonarQubeNotification> notifications = new ArrayList<SonarQubeNotification>();
        try {
            JsonParser parser = new JsonParser();
            JsonObject root = parser.parse(contents).getAsJsonObject();
            JsonArray events = root.get("events").getAsJsonArray();
            for (JsonElement el : events) {
                JsonObject event = el.getAsJsonObject();
                String category = NotificationChecker.getOrFail(event, "category");
                String message = NotificationChecker.getOrFail(event, "message");
                String link = NotificationChecker.getOrFail(event, "link");
                String projectKey = NotificationChecker.getOrFail(event, "project");
                String dateTime = NotificationChecker.getOrFail(event, "date");
                ZonedDateTime time = ZonedDateTime.parse(dateTime, TIME_FORMATTER);
                notifications.add(new DefaultSonarQubeNotification(category, message, link, projectKey, time));
            }
        }
        catch (Exception e) {
            LOG.error("Failed to parse SonarQube notifications response", e);
            return Collections.emptyList();
        }
        return notifications;
    }

    private static String getOrFail(JsonObject parent, String name) {
        JsonElement element = parent.get(name);
        if (element == null) {
            throw new IllegalStateException("Failed to parse response. Missing field '" + name + "'.");
        }
        return element.getAsString();
    }
}

