/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.container.storage.partialupdate;

import java.nio.file.Path;
import java.util.List;
import org.sonar.api.utils.TempFolder;
import org.sonarsource.sonarlint.core.client.api.connected.ServerConfiguration;
import org.sonarsource.sonarlint.core.client.api.exceptions.DownloadException;
import org.sonarsource.sonarlint.core.container.connected.IssueStore;
import org.sonarsource.sonarlint.core.container.connected.IssueStoreFactory;
import org.sonarsource.sonarlint.core.container.connected.SonarLintWsClient;
import org.sonarsource.sonarlint.core.container.connected.update.IssueDownloader;
import org.sonarsource.sonarlint.core.container.connected.update.IssueDownloaderImpl;
import org.sonarsource.sonarlint.core.container.connected.update.ModuleListDownloader;
import org.sonarsource.sonarlint.core.container.connected.update.perform.ServerIssueUpdater;
import org.sonarsource.sonarlint.core.container.storage.IssueStoreReader;
import org.sonarsource.sonarlint.core.container.storage.StoragePaths;
import org.sonarsource.sonarlint.core.container.storage.StorageReader;
import org.sonarsource.sonarlint.core.util.ProgressWrapper;

public class PartialUpdater {
    private final IssueStoreFactory issueStoreFactory;
    private final IssueDownloader downloader;
    private final StorageReader storageReader;
    private final IssueStoreReader issueStoreReader;
    private final ModuleListDownloader moduleListDownloader;
    private final StoragePaths storagePaths;

    public PartialUpdater(IssueStoreFactory issueStoreFactory, IssueDownloader downloader, StorageReader storageReader, StoragePaths storagePaths, IssueStoreReader issueStoreReader, ModuleListDownloader moduleListDownloader) {
        this.issueStoreFactory = issueStoreFactory;
        this.downloader = downloader;
        this.storageReader = storageReader;
        this.storagePaths = storagePaths;
        this.issueStoreReader = issueStoreReader;
        this.moduleListDownloader = moduleListDownloader;
    }

    public static PartialUpdater create(StorageReader storageReader, StoragePaths storagePaths, ServerConfiguration serverConfig, IssueStoreReader issueStoreReader) {
        SonarLintWsClient client = new SonarLintWsClient(serverConfig);
        IssueStoreFactory issueStoreFactory = new IssueStoreFactory();
        IssueDownloaderImpl downloader = new IssueDownloaderImpl(client);
        ModuleListDownloader moduleListDownloader = new ModuleListDownloader(client);
        return new PartialUpdater(issueStoreFactory, downloader, storageReader, storagePaths, issueStoreReader, moduleListDownloader);
    }

    public void updateFileIssues(String moduleKey, String filePath) {
        List issues;
        Path serverIssuesPath = this.storagePaths.getServerIssuesPath(moduleKey);
        IssueStore issueStore = this.issueStoreFactory.apply(serverIssuesPath);
        String fileKey = this.issueStoreReader.getFileKey(moduleKey, filePath);
        try {
            issues = (List)this.downloader.apply(fileKey);
        }
        catch (Exception e) {
            throw new DownloadException("Failed to update file issues: " + e.getMessage(), null);
        }
        issueStore.save(issues);
    }

    public void updateFileIssues(String moduleKey, TempFolder tempFolder) {
        new ServerIssueUpdater(this.storagePaths, this.downloader, this.issueStoreFactory, tempFolder).update(moduleKey);
    }

    public void updateModuleList(ProgressWrapper progress) {
        try {
            this.moduleListDownloader.fetchModulesListTo(this.storagePaths.getGlobalStorageRoot(), this.storageReader.readServerInfos().getVersion(), progress);
        }
        catch (Exception e) {
            throw new DownloadException("Failed to update module list: " + e.getMessage(), null);
        }
    }
}

