/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.container.storage;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.sonarsource.sonarlint.core.container.storage.ProtobufUtil;
import org.sonarsource.sonarlint.core.container.storage.StoragePaths;
import org.sonarsource.sonarlint.core.plugin.PluginIndex;
import org.sonarsource.sonarlint.core.proto.Sonarlint;

public class StoragePluginIndexProvider
implements PluginIndex {
    private StoragePaths storageManager;

    public StoragePluginIndexProvider(StoragePaths storageManager) {
        this.storageManager = storageManager;
    }

    @Override
    public List<PluginIndex.PluginReference> references() {
        Path pluginReferencesPath = this.storageManager.getPluginReferencesPath();
        if (!Files.exists(pluginReferencesPath, new LinkOption[0])) {
            return Collections.emptyList();
        }
        Sonarlint.PluginReferences protoReferences = ProtobufUtil.readFile(pluginReferencesPath, Sonarlint.PluginReferences.parser());
        return protoReferences.getReferenceList().stream().map(r -> new PluginIndex.PluginReference(r.getHash(), r.getFilename())).collect(Collectors.toList());
    }
}

