/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.container.storage;

import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.sonar.api.utils.TempFolder;
import org.sonarsource.sonarlint.core.client.api.common.RuleDetails;
import org.sonarsource.sonarlint.core.client.api.common.analysis.AnalysisResults;
import org.sonarsource.sonarlint.core.client.api.common.analysis.IssueListener;
import org.sonarsource.sonarlint.core.client.api.connected.ConnectedAnalysisConfiguration;
import org.sonarsource.sonarlint.core.client.api.connected.GlobalStorageStatus;
import org.sonarsource.sonarlint.core.client.api.connected.LoadedAnalyzer;
import org.sonarsource.sonarlint.core.client.api.connected.ModuleStorageStatus;
import org.sonarsource.sonarlint.core.client.api.connected.RemoteModule;
import org.sonarsource.sonarlint.core.client.api.connected.ServerConfiguration;
import org.sonarsource.sonarlint.core.client.api.connected.ServerIssue;
import org.sonarsource.sonarlint.core.client.api.util.FileUtils;
import org.sonarsource.sonarlint.core.container.storage.AllModulesReader;
import org.sonarsource.sonarlint.core.container.storage.GlobalUpdateStatusReader;
import org.sonarsource.sonarlint.core.container.storage.IssueStoreReader;
import org.sonarsource.sonarlint.core.container.storage.ModuleStorageStatusReader;
import org.sonarsource.sonarlint.core.container.storage.StorageAnalyzer;
import org.sonarsource.sonarlint.core.container.storage.StorageContainer;
import org.sonarsource.sonarlint.core.container.storage.StoragePaths;
import org.sonarsource.sonarlint.core.container.storage.StorageReader;
import org.sonarsource.sonarlint.core.container.storage.StorageRuleDetailsReader;
import org.sonarsource.sonarlint.core.container.storage.partialupdate.PartialUpdater;
import org.sonarsource.sonarlint.core.plugin.PluginRepository;
import org.sonarsource.sonarlint.core.util.ProgressWrapper;

public class StorageContainerHandler {
    private final StorageAnalyzer storageAnalyzer;
    private final StorageRuleDetailsReader storageRuleDetailsReader;
    private final GlobalUpdateStatusReader globalUpdateStatusReader;
    private final PluginRepository pluginRepository;
    private final ModuleStorageStatusReader moduleStorageStatusReader;
    private final IssueStoreReader issueStoreReader;
    private final AllModulesReader allModulesReader;
    private final StoragePaths storagePaths;
    private final TempFolder tempFolder;
    private final StorageReader storageReader;

    public StorageContainerHandler(StorageAnalyzer storageAnalyzer, StorageRuleDetailsReader storageRuleDetailsReader, GlobalUpdateStatusReader globalUpdateStatusReader, PluginRepository pluginRepository, ModuleStorageStatusReader moduleStorageStatusReader, IssueStoreReader issueStoreReader, AllModulesReader allModulesReader, StoragePaths storagePaths, StorageReader storageReader, TempFolder tempFolder) {
        this.storageAnalyzer = storageAnalyzer;
        this.storageRuleDetailsReader = storageRuleDetailsReader;
        this.globalUpdateStatusReader = globalUpdateStatusReader;
        this.pluginRepository = pluginRepository;
        this.moduleStorageStatusReader = moduleStorageStatusReader;
        this.issueStoreReader = issueStoreReader;
        this.allModulesReader = allModulesReader;
        this.storagePaths = storagePaths;
        this.storageReader = storageReader;
        this.tempFolder = tempFolder;
    }

    public AnalysisResults analyze(StorageContainer container, ConnectedAnalysisConfiguration configuration, IssueListener issueListener, ProgressWrapper progress) {
        return this.storageAnalyzer.analyze(container, configuration, issueListener, progress);
    }

    public RuleDetails getRuleDetails(String ruleKeyStr) {
        return this.storageRuleDetailsReader.apply(ruleKeyStr);
    }

    public GlobalStorageStatus getGlobalStorageStatus() {
        return this.globalUpdateStatusReader.get();
    }

    public Collection<LoadedAnalyzer> getAnalyzers() {
        return this.pluginRepository.getLoadedAnalyzers();
    }

    public ModuleStorageStatus getModuleStorageStatus(String moduleKey) {
        return this.moduleStorageStatusReader.apply(moduleKey);
    }

    public Map<String, RemoteModule> allModulesByKey() {
        return this.allModulesReader.get();
    }

    public List<ServerIssue> getServerIssues(String moduleKey, String filePath) {
        return this.issueStoreReader.getServerIssues(moduleKey, filePath);
    }

    public List<ServerIssue> downloadServerIssues(ServerConfiguration serverConfig, String moduleKey, String filePath) {
        PartialUpdater updater = PartialUpdater.create(this.storageReader, this.storagePaths, serverConfig, this.issueStoreReader);
        updater.updateFileIssues(moduleKey, filePath);
        return this.getServerIssues(moduleKey, filePath);
    }

    public void downloadServerIssues(ServerConfiguration serverConfig, String moduleKey) {
        PartialUpdater updater = PartialUpdater.create(this.storageReader, this.storagePaths, serverConfig, this.issueStoreReader);
        updater.updateFileIssues(moduleKey, this.tempFolder);
    }

    public Map<String, RemoteModule> downloadModuleList(ServerConfiguration serverConfig, ProgressWrapper progress) {
        PartialUpdater updater = PartialUpdater.create(this.storageReader, this.storagePaths, serverConfig, this.issueStoreReader);
        updater.updateModuleList(progress);
        return this.allModulesByKey();
    }

    public void deleteStorage() {
        FileUtils.deleteRecursively((Path)this.storagePaths.getServerStorageRoot());
    }
}

