/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.container.storage;

import javax.annotation.Nullable;
import org.sonarsource.sonarlint.core.analyzer.sensor.AllSensorsExecutor;
import org.sonarsource.sonarlint.core.client.api.common.analysis.AnalysisResults;
import org.sonarsource.sonarlint.core.client.api.common.analysis.IssueListener;
import org.sonarsource.sonarlint.core.client.api.connected.ConnectedAnalysisConfiguration;
import org.sonarsource.sonarlint.core.client.api.connected.GlobalStorageStatus;
import org.sonarsource.sonarlint.core.client.api.connected.ModuleStorageStatus;
import org.sonarsource.sonarlint.core.client.api.exceptions.StorageException;
import org.sonarsource.sonarlint.core.container.analysis.AnalysisContainer;
import org.sonarsource.sonarlint.core.container.connected.DefaultServer;
import org.sonarsource.sonarlint.core.container.model.DefaultAnalysisResult;
import org.sonarsource.sonarlint.core.container.storage.GlobalUpdateStatusReader;
import org.sonarsource.sonarlint.core.container.storage.ModuleStorageStatusReader;
import org.sonarsource.sonarlint.core.container.storage.SonarQubeActiveRulesProvider;
import org.sonarsource.sonarlint.core.container.storage.StorageContainer;
import org.sonarsource.sonarlint.core.util.ProgressWrapper;

public class StorageAnalyzer {
    private final ModuleStorageStatusReader moduleUpdateStatusReader;
    private final GlobalUpdateStatusReader globalUpdateStatusReader;

    public StorageAnalyzer(GlobalUpdateStatusReader globalUpdateStatusReader, ModuleStorageStatusReader moduleUpdateStatusReader) {
        this.globalUpdateStatusReader = globalUpdateStatusReader;
        this.moduleUpdateStatusReader = moduleUpdateStatusReader;
    }

    private void checkStatus(@Nullable String moduleKey) {
        GlobalStorageStatus updateStatus = this.globalUpdateStatusReader.get();
        if (updateStatus == null) {
            throw new StorageException("Missing global data. Please update server.", false);
        }
        if (moduleKey != null) {
            ModuleStorageStatus moduleUpdateStatus = this.moduleUpdateStatusReader.apply(moduleKey);
            if (moduleUpdateStatus == null) {
                throw new StorageException(String.format("No data stored for module '%s'. Please update the binding.", moduleKey), false);
            }
            if (moduleUpdateStatus.isStale()) {
                throw new StorageException(String.format("Stored data for module '%s' is stale because it was created with a different version of SonarLint. Please update the binding.", moduleKey), false);
            }
        }
    }

    public AnalysisResults analyze(StorageContainer container, ConnectedAnalysisConfiguration configuration, IssueListener issueListener, ProgressWrapper progress) {
        this.checkStatus(configuration.moduleKey());
        AnalysisContainer analysisContainer = new AnalysisContainer(container, progress);
        DefaultAnalysisResult defaultAnalysisResult = new DefaultAnalysisResult();
        analysisContainer.add(configuration, issueListener, new SonarQubeActiveRulesProvider(), DefaultServer.class, defaultAnalysisResult, AllSensorsExecutor.class);
        analysisContainer.execute();
        return defaultAnalysisResult;
    }
}

