/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.container.storage;

import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.google.protobuf.Parser;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.sonarsource.sonarlint.core.client.api.exceptions.StorageException;

public class ProtobufUtil {
    private ProtobufUtil() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T extends Message> T readFile(Path file, Parser<T> parser) {
        try (InputStream input = Files.newInputStream(file, new OpenOption[0]);){
            Message message = (Message)parser.parseFrom(input);
            return (T)message;
        }
        catch (IOException e) {
            throw new StorageException("Failed to read file: " + file, (Throwable)e);
        }
    }

    public static void writeToFile(Message message, Path toFile) {
        try (OutputStream out = Files.newOutputStream(toFile, new OpenOption[0]);){
            message.writeTo(out);
        }
        catch (IOException e) {
            throw new StorageException("Unable to write protocol buffer data to file " + toFile, (Throwable)e);
        }
    }

    public static <T extends Message> List<T> readMessages(InputStream input, Parser<T> parser) {
        ArrayList<Message> list = new ArrayList<Message>();
        while (true) {
            Message message;
            try {
                message = (Message)parser.parseDelimitedFrom(input);
            }
            catch (InvalidProtocolBufferException e) {
                throw new IllegalStateException("failed to parse protobuf message", e);
            }
            if (message == null) break;
            list.add(message);
        }
        return list;
    }

    public static <T extends Message> void writeMessages(OutputStream output, Iterator<T> messages) {
        while (messages.hasNext()) {
            ProtobufUtil.writeMessage(output, (Message)messages.next());
        }
    }

    public static <T extends Message> void writeMessages(OutputStream output, Iterable<T> messages) {
        for (Message message : messages) {
            ProtobufUtil.writeMessage(output, message);
        }
    }

    public static <T extends Message> void writeMessage(OutputStream output, T message) {
        try {
            message.writeDelimitedTo(output);
        }
        catch (IOException e) {
            throw new IllegalStateException("failed to write message: " + message, e);
        }
    }
}

