/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.container.storage;

import java.nio.file.Path;
import java.util.Date;
import java.util.function.Function;
import javax.annotation.CheckForNull;
import org.sonarsource.sonarlint.core.client.api.connected.ModuleStorageStatus;
import org.sonarsource.sonarlint.core.container.model.DefaultModuleStorageStatus;
import org.sonarsource.sonarlint.core.container.storage.ProtobufUtil;
import org.sonarsource.sonarlint.core.container.storage.StoragePaths;
import org.sonarsource.sonarlint.core.proto.Sonarlint;

public class ModuleStorageStatusReader
implements Function<String, ModuleStorageStatus> {
    private final StoragePaths storageManager;

    public ModuleStorageStatusReader(StoragePaths storageManager) {
        this.storageManager = storageManager;
    }

    @Override
    @CheckForNull
    public ModuleStorageStatus apply(String moduleKey) {
        Path updateStatusPath = this.storageManager.getModuleUpdateStatusPath(moduleKey);
        if (updateStatusPath.toFile().exists()) {
            Sonarlint.StorageStatus statusFromStorage = ProtobufUtil.readFile(updateStatusPath, Sonarlint.StorageStatus.parser());
            boolean stale = !statusFromStorage.getStorageVersion().equals("1");
            return new DefaultModuleStorageStatus(new Date(statusFromStorage.getUpdateTimestamp()), stale);
        }
        return null;
    }
}

