/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.container.standalone;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Path;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonarsource.sonarlint.core.client.api.exceptions.StorageException;
import org.sonarsource.sonarlint.core.container.standalone.StandalonePluginUrls;
import org.sonarsource.sonarlint.core.plugin.PluginIndex;
import org.sonarsource.sonarlint.core.plugin.cache.PluginCache;

public class StandalonePluginIndex
implements PluginIndex {
    private static final Logger LOG = Loggers.get(StandalonePluginIndex.class);
    private final StandalonePluginUrls pluginUrls;
    private final PluginCache fileCache;

    public StandalonePluginIndex(StandalonePluginUrls pluginUrls, PluginCache fileCache) {
        this.pluginUrls = pluginUrls;
        this.fileCache = fileCache;
    }

    @Override
    public List<PluginIndex.PluginReference> references() {
        return this.pluginUrls.urls().stream().map(this::getFromCacheOrCopy).collect(Collectors.toList());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private PluginIndex.PluginReference getFromCacheOrCopy(URL pluginUrl) {
        try (InputStream is = pluginUrl.openStream();){
            String hash = org.sonarsource.sonarlint.core.util.StringUtils.md5(is);
            String filename = StringUtils.substringAfterLast(pluginUrl.getFile(), "/");
            this.fileCache.get(filename, hash, new FileCopier(pluginUrl));
            PluginIndex.PluginReference pluginReference = new PluginIndex.PluginReference(hash, filename);
            return pluginReference;
        }
        catch (StorageException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Fail to copy plugin from URL: " + pluginUrl, e);
        }
    }

    private static class FileCopier
    implements PluginCache.Copier {
        private final URL url;

        FileCopier(URL pluginUrl) {
            this.url = pluginUrl;
        }

        @Override
        public void copy(String filename, Path toFile) throws IOException {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Copy plugin {} to {}", (Object)this.url, (Object)toFile);
            } else {
                LOG.info("Copy {}", (Object)StringUtils.substringAfterLast(this.url.getFile(), "/"));
            }
            FileUtils.copyURLToFile(this.url, toFile.toFile());
        }
    }
}

