/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.container.global;

import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.ExtensionProvider;
import org.sonar.api.Plugin;
import org.sonar.api.SonarRuntime;
import org.sonar.api.batch.sensor.Sensor;
import org.sonar.api.profiles.ProfileDefinition;
import org.sonarsource.sonarlint.core.container.ComponentContainer;
import org.sonarsource.sonarlint.core.container.global.ExtensionUtils;
import org.sonarsource.sonarlint.core.plugin.PluginCacheLoader;
import org.sonarsource.sonarlint.core.plugin.PluginInfo;
import org.sonarsource.sonarlint.core.plugin.PluginRepository;

public class ExtensionInstaller {
    private static final Logger LOG = LoggerFactory.getLogger(ExtensionInstaller.class);
    private final SonarRuntime sqRuntime;
    private final PluginRepository pluginRepository;

    public ExtensionInstaller(SonarRuntime sqRuntime, PluginRepository pluginRepository) {
        this.sqRuntime = sqRuntime;
        this.pluginRepository = pluginRepository;
    }

    public ExtensionInstaller install(ComponentContainer container) {
        for (PluginInfo pluginInfo : this.pluginRepository.getPluginInfos()) {
            Plugin plugin = this.pluginRepository.getPluginInstance(pluginInfo.getKey());
            Plugin.Context context = new Plugin.Context(this.sqRuntime);
            plugin.define(context);
            ExtensionInstaller.loadExtensions(container, pluginInfo, context);
        }
        List<ExtensionProvider> providers = container.getComponentsByType(ExtensionProvider.class);
        for (ExtensionProvider provider : providers) {
            Object object = provider.provide();
            if (object instanceof Iterable) {
                for (Object extension : (Iterable)object) {
                    container.addExtension(null, extension);
                }
                continue;
            }
            container.addExtension(null, object);
        }
        return this;
    }

    private static void loadExtensions(ComponentContainer container, PluginInfo pluginInfo, Plugin.Context context) {
        for (Object extension : context.getExtensions()) {
            boolean isExplicitlySonarLintCompatible;
            Boolean isSlPluginOrNull = pluginInfo.isSonarLintSupported();
            boolean bl = isExplicitlySonarLintCompatible = isSlPluginOrNull != null && isSlPluginOrNull != false;
            if (isExplicitlySonarLintCompatible) {
                if (!ExtensionUtils.isSonarLintSide(extension) || !PluginCacheLoader.isWhitelisted(pluginInfo.getKey()) && !ExtensionInstaller.isNotSensor(extension)) continue;
                container.addExtension(pluginInfo, extension);
                continue;
            }
            if (!ExtensionInstaller.blacklisted(extension) && (ExtensionUtils.isScannerSide(extension) || ExtensionUtils.isType(extension, ProfileDefinition.class))) {
                container.addExtension(pluginInfo, extension);
                continue;
            }
            LOG.debug("Extension {} was blacklisted as it is not used by SonarLint", (Object)ExtensionInstaller.className(extension));
        }
    }

    private static boolean isNotSensor(Object extension) {
        return !ExtensionUtils.isType(extension, Sensor.class) && !ExtensionUtils.isType(extension, org.sonar.api.batch.Sensor.class);
    }

    private static boolean blacklisted(Object extension) {
        String className = ExtensionInstaller.className(extension);
        return className.contains("JaCoCo") || className.contains("Surefire") || className.contains("Coverage") || className.contains("COV") || className.contains("PhpUnit") || className.contains("XUnit") || className.contains("Pylint");
    }

    private static String className(Object extension) {
        return extension instanceof Class ? ((Class)extension).getName() : extension.getClass().getName();
    }
}

