/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.container.connected.validate;

import com.google.gson.Gson;
import org.sonarsource.sonarlint.core.client.api.connected.ValidationResult;
import org.sonarsource.sonarlint.core.container.connected.SonarLintWsClient;
import org.sonarsource.sonarlint.core.container.connected.validate.DefaultValidationResult;
import org.sonarsource.sonarlint.core.util.ws.WsResponse;

public class AuthenticationChecker {
    private final SonarLintWsClient wsClient;

    public AuthenticationChecker(SonarLintWsClient wsClient) {
        this.wsClient = wsClient;
    }

    public ValidationResult validateCredentials() {
        try (WsResponse response = this.wsClient.rawGet("api/authentication/validate?format=json");){
            int code = response.code();
            if (response.isSuccessful()) {
                String responseStr = response.content();
                ValidateResponse validateResponse = new Gson().fromJson(responseStr, ValidateResponse.class);
                DefaultValidationResult defaultValidationResult = new DefaultValidationResult(validateResponse.valid, validateResponse.valid ? "Authentication successful" : "Authentication failed");
                return defaultValidationResult;
            }
            DefaultValidationResult defaultValidationResult = new DefaultValidationResult(false, "HTTP Connection failed (" + code + "): " + response.content());
            return defaultValidationResult;
        }
    }

    private static class ValidateResponse {
        boolean valid;

        private ValidateResponse() {
        }
    }
}

