/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.container.connected.update.perform;

import java.nio.file.Path;
import java.util.List;
import org.sonar.api.utils.TempFolder;
import org.sonarsource.sonarlint.core.client.api.util.FileUtils;
import org.sonarsource.sonarlint.core.container.connected.IssueStoreFactory;
import org.sonarsource.sonarlint.core.container.connected.update.IssueDownloader;
import org.sonarsource.sonarlint.core.container.storage.StoragePaths;

public class ServerIssueUpdater {
    private final StoragePaths storagePaths;
    private final IssueDownloader issueDownloader;
    private final IssueStoreFactory issueStoreFactory;
    private final TempFolder tempFolder;

    public ServerIssueUpdater(StoragePaths storagePaths, IssueDownloader issueDownloader, IssueStoreFactory issueStoreFactory, TempFolder tempFolder) {
        this.storagePaths = storagePaths;
        this.issueDownloader = issueDownloader;
        this.issueStoreFactory = issueStoreFactory;
        this.tempFolder = tempFolder;
    }

    public void update(String moduleKey) {
        Path work = this.tempFolder.newDir().toPath();
        Path target = this.storagePaths.getServerIssuesPath(moduleKey);
        FileUtils.replaceDir(temp -> this.updateServerIssues(moduleKey, (Path)temp), (Path)target, (Path)work);
    }

    public void updateServerIssues(String moduleKey, Path temp) {
        List issues = (List)this.issueDownloader.apply(moduleKey);
        this.issueStoreFactory.apply(temp).save(issues);
    }
}

