/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.container.connected.update.perform;

import java.nio.file.Path;
import java.util.Date;
import java.util.Set;
import org.sonar.api.utils.TempFolder;
import org.sonarsource.sonarlint.core.client.api.util.FileUtils;
import org.sonarsource.sonarlint.core.container.connected.IssueStoreFactory;
import org.sonarsource.sonarlint.core.container.connected.SonarLintWsClient;
import org.sonarsource.sonarlint.core.container.connected.update.IssueDownloader;
import org.sonarsource.sonarlint.core.container.connected.update.ModuleConfigurationDownloader;
import org.sonarsource.sonarlint.core.container.connected.update.perform.ServerIssueUpdater;
import org.sonarsource.sonarlint.core.container.storage.ProtobufUtil;
import org.sonarsource.sonarlint.core.container.storage.StoragePaths;
import org.sonarsource.sonarlint.core.container.storage.StorageReader;
import org.sonarsource.sonarlint.core.proto.Sonarlint;
import org.sonarsource.sonarlint.core.util.ProgressWrapper;
import org.sonarsource.sonarlint.core.util.VersionUtils;

public class ModuleStorageUpdateExecutor {
    private final StorageReader storageReader;
    private final SonarLintWsClient wsClient;
    private final IssueDownloader issueDownloader;
    private final IssueStoreFactory issueStoreFactory;
    private final TempFolder tempFolder;
    private final ModuleConfigurationDownloader moduleConfigurationDownloader;
    private final StoragePaths storagePaths;

    public ModuleStorageUpdateExecutor(StorageReader storageReader, StoragePaths storagePaths, SonarLintWsClient wsClient, IssueDownloader issueDownloader, IssueStoreFactory issueStoreFactory, TempFolder tempFolder, ModuleConfigurationDownloader moduleConfigurationDownloader) {
        this.storageReader = storageReader;
        this.storagePaths = storagePaths;
        this.wsClient = wsClient;
        this.issueDownloader = issueDownloader;
        this.issueStoreFactory = issueStoreFactory;
        this.tempFolder = tempFolder;
        this.moduleConfigurationDownloader = moduleConfigurationDownloader;
    }

    public void update(String moduleKey, ProgressWrapper progress) {
        Sonarlint.GlobalProperties globalProps = this.storageReader.readGlobalProperties();
        FileUtils.replaceDir(temp -> {
            this.updateModuleConfiguration(moduleKey, globalProps, (Path)temp, progress);
            this.updateRemoteIssues(moduleKey, (Path)temp);
            this.updateStatus((Path)temp);
        }, (Path)this.storagePaths.getModuleStorageRoot(moduleKey), (Path)this.tempFolder.newDir().toPath());
    }

    private void updateModuleConfiguration(String moduleKey, Sonarlint.GlobalProperties globalProps, Path temp, ProgressWrapper progress) {
        Sonarlint.ModuleConfiguration moduleConfiguration = this.moduleConfigurationDownloader.fetchModuleConfiguration(this.storageReader.readServerInfos().getVersion(), moduleKey, globalProps, progress);
        Set<String> qProfileKeys = this.storageReader.readQProfiles().getQprofilesByKeyMap().keySet();
        for (String qpKey : moduleConfiguration.getQprofilePerLanguageMap().values()) {
            if (qProfileKeys.contains(qpKey)) continue;
            throw new IllegalStateException("Module '" + moduleKey + "' is associated to quality profile '" + qpKey + "' that is not in the storage. The SonarQube server binding is probably outdated,  please update it.");
        }
        ProtobufUtil.writeToFile(moduleConfiguration, temp.resolve("configuration.pb"));
    }

    private void updateRemoteIssues(String moduleKey, Path temp) {
        Path basedir = temp.resolve("server_issues");
        new ServerIssueUpdater(this.storagePaths, this.issueDownloader, this.issueStoreFactory, this.tempFolder).updateServerIssues(moduleKey, basedir);
    }

    private void updateStatus(Path temp) {
        Sonarlint.StorageStatus storageStatus = Sonarlint.StorageStatus.newBuilder().setStorageVersion("1").setClientUserAgent(this.wsClient.getUserAgent()).setSonarlintCoreVersion(VersionUtils.getLibraryVersion()).setUpdateTimestamp(new Date().getTime()).build();
        ProtobufUtil.writeToFile(storageStatus, temp.resolve("storage_status.pb"));
    }
}

