/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.container.connected.update.perform;

import java.nio.file.Path;
import java.util.Date;
import java.util.List;
import org.sonar.api.utils.TempFolder;
import org.sonarsource.sonarlint.core.client.api.connected.SonarAnalyzer;
import org.sonarsource.sonarlint.core.client.api.util.FileUtils;
import org.sonarsource.sonarlint.core.container.connected.SonarLintWsClient;
import org.sonarsource.sonarlint.core.container.connected.update.ModuleListDownloader;
import org.sonarsource.sonarlint.core.container.connected.update.PluginListDownloader;
import org.sonarsource.sonarlint.core.container.connected.update.PluginReferencesDownloader;
import org.sonarsource.sonarlint.core.container.connected.update.QualityProfilesDownloader;
import org.sonarsource.sonarlint.core.container.connected.update.RulesDownloader;
import org.sonarsource.sonarlint.core.container.connected.update.SettingsDownloader;
import org.sonarsource.sonarlint.core.container.connected.validate.ServerVersionAndStatusChecker;
import org.sonarsource.sonarlint.core.container.storage.ProtobufUtil;
import org.sonarsource.sonarlint.core.container.storage.StoragePaths;
import org.sonarsource.sonarlint.core.proto.Sonarlint;
import org.sonarsource.sonarlint.core.util.ProgressWrapper;
import org.sonarsource.sonarlint.core.util.VersionUtils;

public class GlobalStorageUpdateExecutor {
    private final StoragePaths storageManager;
    private final PluginReferencesDownloader pluginReferenceDownloader;
    private final SettingsDownloader globalSettingsDownloader;
    private final RulesDownloader rulesDownloader;
    private final TempFolder tempFolder;
    private final ModuleListDownloader moduleListDownloader;
    private final ServerVersionAndStatusChecker statusChecker;
    private final SonarLintWsClient wsClient;
    private final QualityProfilesDownloader qualityProfilesDownloader;
    private final PluginListDownloader pluginListDownloader;

    public GlobalStorageUpdateExecutor(StoragePaths storageManager, SonarLintWsClient wsClient, ServerVersionAndStatusChecker statusChecker, PluginReferencesDownloader pluginReferenceDownloader, SettingsDownloader globalPropertiesDownloader, RulesDownloader rulesDownloader, ModuleListDownloader moduleListDownloader, QualityProfilesDownloader qualityProfilesDownloader, PluginListDownloader pluginListDownloader, TempFolder tempFolder) {
        this.storageManager = storageManager;
        this.wsClient = wsClient;
        this.statusChecker = statusChecker;
        this.pluginReferenceDownloader = pluginReferenceDownloader;
        this.globalSettingsDownloader = globalPropertiesDownloader;
        this.rulesDownloader = rulesDownloader;
        this.moduleListDownloader = moduleListDownloader;
        this.qualityProfilesDownloader = qualityProfilesDownloader;
        this.pluginListDownloader = pluginListDownloader;
        this.tempFolder = tempFolder;
    }

    public List<SonarAnalyzer> update(ProgressWrapper progress) {
        Path temp = this.tempFolder.newDir().toPath();
        try {
            progress.setProgressAndCheckCancel("Checking server version and status", 0.1f);
            Sonarlint.ServerInfos serverStatus = this.statusChecker.checkVersionAndStatus();
            progress.setProgressAndCheckCancel("Fetching list of analyzers", 0.12f);
            List<SonarAnalyzer> analyzers = this.pluginListDownloader.downloadPluginList(serverStatus.getVersion());
            ProtobufUtil.writeToFile(serverStatus, temp.resolve("server_info.pb"));
            progress.setProgressAndCheckCancel("Fetching global properties", 0.15f);
            this.globalSettingsDownloader.fetchGlobalSettingsTo(serverStatus.getVersion(), temp);
            progress.setProgressAndCheckCancel("Fetching analyzers", 0.25f);
            this.pluginReferenceDownloader.fetchPluginsTo(temp, analyzers);
            progress.setProgressAndCheckCancel("Fetching rules", 0.4f);
            this.rulesDownloader.fetchRulesTo(temp, progress.subProgress(0.4f, 0.6f, "Fetching rules"));
            progress.setProgressAndCheckCancel("Fetching quality profiles", 0.6f);
            this.qualityProfilesDownloader.fetchQualityProfilesTo(temp);
            progress.setProgressAndCheckCancel("Fetching list of modules", 0.8f);
            this.moduleListDownloader.fetchModulesListTo(temp, serverStatus.getVersion(), progress.subProgress(0.8f, 1.0f, "Fetching list of modules"));
            progress.startNonCancelableSection();
            progress.setProgressAndCheckCancel("Finalizing...", 1.0f);
            Sonarlint.StorageStatus storageStatus = Sonarlint.StorageStatus.newBuilder().setStorageVersion("1").setClientUserAgent(this.wsClient.getUserAgent()).setSonarlintCoreVersion(VersionUtils.getLibraryVersion()).setUpdateTimestamp(new Date().getTime()).build();
            ProtobufUtil.writeToFile(storageStatus, temp.resolve("storage_status.pb"));
            Path dest = this.storageManager.getGlobalStorageRoot();
            FileUtils.deleteRecursively((Path)dest);
            FileUtils.mkdirs((Path)dest.getParent());
            FileUtils.moveDir((Path)temp, (Path)dest);
            return analyzers;
        }
        catch (RuntimeException e) {
            try {
                FileUtils.deleteRecursively((Path)temp);
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
            throw e;
        }
    }
}

