/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.container.connected.update.check;

import com.google.common.collect.MapDifference;
import com.google.common.collect.Maps;
import java.util.Map;
import org.sonarsource.sonarlint.core.container.connected.update.QualityProfilesDownloader;
import org.sonarsource.sonarlint.core.container.connected.update.check.DefaultStorageUpdateCheckResult;
import org.sonarsource.sonarlint.core.container.storage.StorageReader;
import org.sonarsource.sonarlint.core.proto.Sonarlint;

public class QualityProfilesUpdateChecker {
    private final StorageReader storageReader;
    private final QualityProfilesDownloader qualityProfilesDownloader;

    public QualityProfilesUpdateChecker(StorageReader storageReader, QualityProfilesDownloader qualityProfilesDownloader) {
        this.storageReader = storageReader;
        this.qualityProfilesDownloader = qualityProfilesDownloader;
    }

    public void checkForUpdates(DefaultStorageUpdateCheckResult result) {
        Sonarlint.QProfiles serverQualityProfiles = this.qualityProfilesDownloader.fetchQualityProfiles();
        Sonarlint.QProfiles storageQProfiles = this.storageReader.readQProfiles();
        Map<String, Sonarlint.QProfiles.QProfile> serverPluginHashes = serverQualityProfiles.getQprofilesByKeyMap();
        Map<String, Sonarlint.QProfiles.QProfile> storagePluginHashes = storageQProfiles.getQprofilesByKeyMap();
        MapDifference<String, Sonarlint.QProfiles.QProfile> pluginDiff = Maps.difference(storagePluginHashes, serverPluginHashes);
        if (!pluginDiff.areEqual()) {
            for (Map.Entry<String, Sonarlint.QProfiles.QProfile> entry : pluginDiff.entriesOnlyOnLeft().entrySet()) {
                result.appendToChangelog(String.format("Quality profile '%s' for language '%s' removed", entry.getValue().getName(), entry.getValue().getLanguageName()));
            }
            for (Map.Entry<String, Sonarlint.QProfiles.QProfile> entry : pluginDiff.entriesOnlyOnRight().entrySet()) {
                result.appendToChangelog(String.format("Quality profile '%s' for language '%s' added", entry.getValue().getName(), entry.getValue().getLanguageName()));
            }
            for (Map.Entry<String, Object> entry : pluginDiff.entriesDiffering().entrySet()) {
                result.appendToChangelog(String.format("Quality profile '%s' for language '%s' updated", ((Sonarlint.QProfiles.QProfile)((MapDifference.ValueDifference)entry.getValue()).rightValue()).getName(), ((Sonarlint.QProfiles.QProfile)((MapDifference.ValueDifference)entry.getValue()).rightValue()).getLanguageName()));
            }
        }
    }
}

