/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.container.connected.update.check;

import com.google.common.collect.MapDifference;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.sonarsource.sonarlint.core.client.api.connected.SonarAnalyzer;
import org.sonarsource.sonarlint.core.container.connected.update.PluginReferencesDownloader;
import org.sonarsource.sonarlint.core.container.connected.update.check.DefaultStorageUpdateCheckResult;
import org.sonarsource.sonarlint.core.container.storage.StorageReader;
import org.sonarsource.sonarlint.core.proto.Sonarlint;

public class PluginsUpdateChecker {
    private final StorageReader storageReader;
    private final PluginReferencesDownloader pluginReferenceDownloader;

    public PluginsUpdateChecker(StorageReader storageReader, PluginReferencesDownloader pluginReferenceDownloader) {
        this.storageReader = storageReader;
        this.pluginReferenceDownloader = pluginReferenceDownloader;
    }

    public void checkForUpdates(DefaultStorageUpdateCheckResult result, List<SonarAnalyzer> pluginList) {
        Sonarlint.PluginReferences serverPluginReferences = this.pluginReferenceDownloader.fetchPlugins(pluginList);
        Sonarlint.PluginReferences storagePluginReferences = this.storageReader.readPluginReferences();
        Map<String, String> serverPluginHashes = serverPluginReferences.getReferenceList().stream().collect(Collectors.toMap(Sonarlint.PluginReferences.PluginReference::getKey, Sonarlint.PluginReferences.PluginReference::getHash));
        Map<String, String> storagePluginHashes = storagePluginReferences.getReferenceList().stream().collect(Collectors.toMap(Sonarlint.PluginReferences.PluginReference::getKey, Sonarlint.PluginReferences.PluginReference::getHash));
        MapDifference<String, String> pluginDiff = Maps.difference(storagePluginHashes, serverPluginHashes);
        if (!pluginDiff.areEqual()) {
            for (Map.Entry<String, String> entry : pluginDiff.entriesOnlyOnLeft().entrySet()) {
                result.appendToChangelog(String.format("Plugin '%s' removed", entry.getKey()));
            }
            for (Map.Entry<String, String> entry : pluginDiff.entriesOnlyOnRight().entrySet()) {
                result.appendToChangelog("Plugin '" + entry.getKey() + "' added");
            }
            for (Map.Entry<String, Object> entry : pluginDiff.entriesDiffering().entrySet()) {
                result.appendToChangelog("Plugin '" + entry.getKey() + "' updated");
            }
        }
    }
}

