/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.container.connected.update.check;

import java.util.List;
import org.sonarsource.sonarlint.core.client.api.connected.SonarAnalyzer;
import org.sonarsource.sonarlint.core.client.api.connected.StorageUpdateCheckResult;
import org.sonarsource.sonarlint.core.container.connected.update.PluginListDownloader;
import org.sonarsource.sonarlint.core.container.connected.update.check.DefaultStorageUpdateCheckResult;
import org.sonarsource.sonarlint.core.container.connected.update.check.GlobalSettingsUpdateChecker;
import org.sonarsource.sonarlint.core.container.connected.update.check.PluginsUpdateChecker;
import org.sonarsource.sonarlint.core.container.connected.update.check.QualityProfilesUpdateChecker;
import org.sonarsource.sonarlint.core.container.connected.validate.ServerVersionAndStatusChecker;
import org.sonarsource.sonarlint.core.proto.Sonarlint;
import org.sonarsource.sonarlint.core.util.ProgressWrapper;

public class GlobalStorageUpdateChecker {
    private final PluginsUpdateChecker pluginsUpdateChecker;
    private final GlobalSettingsUpdateChecker globalSettingsUpdateChecker;
    private final ServerVersionAndStatusChecker statusChecker;
    private final QualityProfilesUpdateChecker qualityProfilesUpdateChecker;
    private final PluginListDownloader pluginListDownloader;

    public GlobalStorageUpdateChecker(ServerVersionAndStatusChecker statusChecker, PluginsUpdateChecker pluginsUpdateChecker, PluginListDownloader pluginListDownloader, GlobalSettingsUpdateChecker globalSettingsUpdateChecker, QualityProfilesUpdateChecker qualityProfilesUpdateChecker) {
        this.statusChecker = statusChecker;
        this.pluginsUpdateChecker = pluginsUpdateChecker;
        this.pluginListDownloader = pluginListDownloader;
        this.globalSettingsUpdateChecker = globalSettingsUpdateChecker;
        this.qualityProfilesUpdateChecker = qualityProfilesUpdateChecker;
    }

    public StorageUpdateCheckResult checkForUpdate(ProgressWrapper progress) {
        DefaultStorageUpdateCheckResult result = new DefaultStorageUpdateCheckResult();
        progress.setProgressAndCheckCancel("Checking server version and status", 0.1f);
        Sonarlint.ServerInfos serverStatus = this.statusChecker.checkVersionAndStatus();
        progress.setProgressAndCheckCancel("Checking global properties", 0.3f);
        this.globalSettingsUpdateChecker.checkForUpdates(serverStatus.getVersion(), result);
        progress.setProgressAndCheckCancel("Checking plugins", 0.5f);
        List<SonarAnalyzer> pluginList = this.pluginListDownloader.downloadPluginList(serverStatus.getVersion());
        this.pluginsUpdateChecker.checkForUpdates(result, pluginList);
        progress.setProgressAndCheckCancel("Checking quality profiles", 0.7f);
        this.qualityProfilesUpdateChecker.checkForUpdates(result);
        progress.setProgressAndCheckCancel("Done", 1.0f);
        return result;
    }
}

