/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.container.connected.update;

import com.google.common.base.Joiner;
import com.google.gson.stream.JsonReader;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.BiPredicate;
import javax.annotation.Nullable;
import org.sonarqube.ws.Settings;
import org.sonarsource.sonarlint.core.container.connected.SonarLintWsClient;
import org.sonarsource.sonarlint.core.container.storage.ProtobufUtil;
import org.sonarsource.sonarlint.core.plugin.Version;
import org.sonarsource.sonarlint.core.proto.Sonarlint;
import org.sonarsource.sonarlint.core.util.StringUtils;
import org.sonarsource.sonarlint.core.util.ws.WsResponse;

public class SettingsDownloader {
    private static final String API_SETTINGS_PATH = "/api/settings/values.protobuf";
    private static final String API_PROPERTIES_PATH = "/api/properties?format=json";
    private final SonarLintWsClient wsClient;

    public SettingsDownloader(SonarLintWsClient wsClient) {
        this.wsClient = wsClient;
    }

    public void fetchGlobalSettingsTo(String serverVersion, Path dest) {
        ProtobufUtil.writeToFile(this.fetchGlobalSettings(serverVersion), dest.resolve("properties.pb"));
    }

    public Sonarlint.GlobalProperties fetchGlobalSettings(String serverVersion) {
        Sonarlint.GlobalProperties.Builder builder = Sonarlint.GlobalProperties.newBuilder();
        this.fetchSettings(serverVersion, null, (k, v) -> true, builder::putProperties);
        return builder.build();
    }

    public void fetchProjectSettings(String serverVersion, String moduleKey, Sonarlint.GlobalProperties globalProps, Sonarlint.ModuleConfiguration.Builder projectConfigurationBuilder) {
        this.fetchSettings(serverVersion, moduleKey, (k, v) -> !v.equals(globalProps.getPropertiesMap().get(k)), projectConfigurationBuilder::putProperties);
    }

    private void fetchSettings(String serverVersion, @Nullable String moduleKey, BiPredicate<String, String> filter, BiConsumer<String, String> consumer) {
        if (Version.create(serverVersion).compareToIgnoreQualifier(Version.create("6.3")) >= 0) {
            this.fetchUsingSettingsWS(moduleKey, consumer);
        } else {
            this.fetchUsingPropertiesWS(moduleKey, filter, consumer);
        }
    }

    private void fetchUsingSettingsWS(@Nullable String moduleKey, BiConsumer<String, String> consumer) {
        String url = API_SETTINGS_PATH;
        if (moduleKey != null) {
            url = url + "?component=" + StringUtils.urlEncode(moduleKey);
        }
        WsResponse response = this.wsClient.get(url);
        try (InputStream is = response.contentStream();){
            Settings.ValuesWsResponse values = Settings.ValuesWsResponse.parseFrom(is);
            for (Settings.Setting s : values.getSettingsList()) {
                if (s.getInherited()) continue;
                this.processSetting(consumer, s);
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to parse properties from: " + response.content(), e);
        }
    }

    private void processSetting(BiConsumer<String, String> consumer, Settings.Setting s) {
        switch (s.getValueOneOfCase()) {
            case VALUE: {
                consumer.accept(s.getKey(), s.getValue());
                break;
            }
            case VALUES: {
                consumer.accept(s.getKey(), Joiner.on(',').join(s.getValues().getValuesList()));
                break;
            }
            case FIELDVALUES: {
                SettingsDownloader.processPropertySet(s, consumer);
                break;
            }
            default: {
                throw new IllegalStateException("Unknow property value for " + s.getKey());
            }
        }
    }

    private static void processPropertySet(Settings.Setting s, BiConsumer<String, String> consumer) {
        ArrayList<String> ids = new ArrayList<String>();
        int id = 1;
        for (Settings.FieldValues.Value v : s.getFieldValues().getFieldValuesList()) {
            for (Map.Entry<String, String> entry : v.getValue().entrySet()) {
                consumer.accept(s.getKey() + "." + id + "." + entry.getKey(), entry.getValue());
            }
            ids.add(String.valueOf(id));
            ++id;
        }
        consumer.accept(s.getKey(), Joiner.on(',').join(ids));
    }

    private void fetchUsingPropertiesWS(@Nullable String moduleKey, BiPredicate<String, String> filter, BiConsumer<String, String> consumer) {
        String url = API_PROPERTIES_PATH;
        if (moduleKey != null) {
            url = url + "&resource=" + StringUtils.urlEncode(moduleKey);
        }
        try (WsResponse response = this.wsClient.get(url);){
            try (JsonReader reader = new JsonReader(response.contentReader());){
                reader.beginArray();
                while (reader.hasNext()) {
                    reader.beginObject();
                    SettingsDownloader.parseProperty(filter, consumer, reader);
                    reader.endObject();
                }
                reader.endArray();
            }
            catch (IOException e) {
                throw new IllegalStateException("Unable to parse properties from: " + response.content(), e);
            }
        }
    }

    private static void parseProperty(BiPredicate<String, String> filter, BiConsumer<String, String> consumer, JsonReader reader) throws IOException {
        String key = null;
        String value = null;
        block8: while (reader.hasNext()) {
            String propName;
            switch (propName = reader.nextName()) {
                case "key": {
                    key = reader.nextString();
                    continue block8;
                }
                case "value": {
                    value = reader.nextString();
                    continue block8;
                }
            }
            reader.skipValue();
        }
        if (filter.test(key, value)) {
            consumer.accept(key, value);
        }
    }
}

