/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.container.connected.update;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import org.sonarqube.ws.QualityProfiles;
import org.sonarsource.sonarlint.core.container.connected.SonarLintWsClient;
import org.sonarsource.sonarlint.core.container.storage.ProtobufUtil;
import org.sonarsource.sonarlint.core.proto.Sonarlint;
import org.sonarsource.sonarlint.core.util.StringUtils;

public class QualityProfilesDownloader {
    private static final String DEFAULT_QP_SEARCH_URL = "/api/qualityprofiles/search.protobuf";
    private final SonarLintWsClient wsClient;

    public QualityProfilesDownloader(SonarLintWsClient wsClient) {
        this.wsClient = wsClient;
    }

    public void fetchQualityProfilesTo(Path destDir) {
        ProtobufUtil.writeToFile(this.fetchQualityProfiles(), destDir.resolve("quality_profiles.pb"));
    }

    public Sonarlint.QProfiles fetchQualityProfiles() {
        Sonarlint.QProfiles.Builder qProfileBuilder = Sonarlint.QProfiles.newBuilder();
        String searchUrl = DEFAULT_QP_SEARCH_URL;
        if (this.wsClient.getOrganizationKey() != null) {
            searchUrl = searchUrl + "?organization=" + StringUtils.urlEncode(this.wsClient.getOrganizationKey());
        }
        try (InputStream contentStream = this.wsClient.get(searchUrl).contentStream();){
            QualityProfiles.SearchWsResponse qpResponse = QualityProfiles.SearchWsResponse.parseFrom(contentStream);
            for (QualityProfiles.SearchWsResponse.QualityProfile qp : qpResponse.getProfilesList()) {
                Sonarlint.QProfiles.QProfile.Builder qpBuilder = Sonarlint.QProfiles.QProfile.newBuilder();
                qpBuilder.setKey(qp.getKey());
                qpBuilder.setName(qp.getName());
                qpBuilder.setLanguage(qp.getLanguage());
                qpBuilder.setLanguageName(qp.getLanguageName());
                qpBuilder.setActiveRuleCount(qp.getActiveRuleCount());
                qpBuilder.setRulesUpdatedAt(qp.getRulesUpdatedAt());
                qpBuilder.setUserUpdatedAt(qp.getUserUpdatedAt());
                qProfileBuilder.putQprofilesByKey(qp.getKey(), qpBuilder.build());
                if (!qp.getIsDefault()) continue;
                qProfileBuilder.putDefaultQProfilesByLanguage(qp.getLanguage(), qp.getKey());
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to load default quality profiles", e);
        }
        return qProfileBuilder.build();
    }
}

