/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.container.connected.update;

import com.google.gson.Gson;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Path;
import org.sonarqube.ws.WsComponents;
import org.sonarsource.sonarlint.core.container.connected.SonarLintWsClient;
import org.sonarsource.sonarlint.core.container.storage.ProtobufUtil;
import org.sonarsource.sonarlint.core.plugin.Version;
import org.sonarsource.sonarlint.core.proto.Sonarlint;
import org.sonarsource.sonarlint.core.util.ProgressWrapper;
import org.sonarsource.sonarlint.core.util.StringUtils;
import org.sonarsource.sonarlint.core.util.ws.WsResponse;

public class ModuleListDownloader {
    static final int PAGE_SIZE = 500;
    private final SonarLintWsClient wsClient;

    public ModuleListDownloader(SonarLintWsClient wsClient) {
        this.wsClient = wsClient;
    }

    public void fetchModulesListTo(Path dest, String serverVersion, ProgressWrapper progress) {
        if (Version.create(serverVersion).compareToIgnoreQualifier(Version.create("6.3")) >= 0) {
            this.fetchModulesListAfter6dot3(dest, progress);
        } else {
            this.fetchModulesListBefore6dot3(dest);
        }
    }

    private void fetchModulesListAfter6dot3(Path dest, ProgressWrapper progress) {
        Sonarlint.ModuleList.Builder moduleListBuilder = Sonarlint.ModuleList.newBuilder();
        Sonarlint.ModuleList.Module.Builder moduleBuilder = Sonarlint.ModuleList.Module.newBuilder();
        String baseUrl = "api/components/search.protobuf?qualifiers=TRK,BRC";
        if (this.wsClient.getOrganizationKey() != null) {
            baseUrl = baseUrl + "&organization=" + StringUtils.urlEncode(this.wsClient.getOrganizationKey());
        }
        SonarLintWsClient.getPaginated(this.wsClient, baseUrl, WsComponents.SearchWsResponse::parseFrom, WsComponents.SearchWsResponse::getPaging, WsComponents.SearchWsResponse::getComponentsList, module -> {
            moduleBuilder.clear();
            moduleListBuilder.putModulesByKey(module.getKey(), moduleBuilder.setProjectKey(module.getProject()).setKey(module.getKey()).setName(module.getName()).setQu(module.getQualifier()).build());
        }, progress);
        ProtobufUtil.writeToFile(moduleListBuilder.build(), dest.resolve("module_list.pb"));
    }

    private void fetchModulesListBefore6dot3(Path dest) {
        try (WsResponse response = this.wsClient.get("api/projects/index?format=json&subprojects=true");){
            try (Reader contentReader = response.contentReader();){
                DefaultModule[] results = new Gson().fromJson(contentReader, DefaultModule[].class);
                Sonarlint.ModuleList.Builder moduleListBuilder = Sonarlint.ModuleList.newBuilder();
                Sonarlint.ModuleList.Module.Builder moduleBuilder = Sonarlint.ModuleList.Module.newBuilder();
                for (DefaultModule module : results) {
                    moduleBuilder.clear();
                    moduleListBuilder.putModulesByKey(module.k, moduleBuilder.setKey(module.k).setName(module.nm).setQu(module.qu).build());
                }
                ProtobufUtil.writeToFile(moduleListBuilder.build(), dest.resolve("module_list.pb"));
            }
            catch (IOException e) {
                throw new IllegalStateException("Failed to load module list", e);
            }
        }
    }

    private static class DefaultModule {
        String k;
        String nm;
        String qu;

        private DefaultModule() {
        }
    }
}

