/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.container.connected.update;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.CheckForNull;
import org.sonarqube.ws.WsComponents;
import org.sonarsource.sonarlint.core.client.api.util.FileUtils;
import org.sonarsource.sonarlint.core.container.connected.SonarLintWsClient;
import org.sonarsource.sonarlint.core.util.ProgressWrapper;
import org.sonarsource.sonarlint.core.util.StringUtils;
import org.sonarsource.sonarlint.core.util.ws.WsResponse;

public class ModuleHierarchyDownloader {
    static final int PAGE_SIZE = 500;
    private final SonarLintWsClient wsClient;

    public ModuleHierarchyDownloader(SonarLintWsClient wsClient) {
        this.wsClient = wsClient;
    }

    public Map<String, String> fetchModuleHierarchy(String moduleKey, ProgressWrapper progress) {
        ArrayList modules = new ArrayList();
        SonarLintWsClient.getPaginated(this.wsClient, "api/components/tree.protobuf?qualifiers=BRC&baseComponentKey=" + StringUtils.urlEncode(moduleKey), WsComponents.TreeWsResponse::parseFrom, WsComponents.TreeWsResponse::getPaging, WsComponents.TreeWsResponse::getComponentsList, modules::add, progress);
        Map modulesById = modules.stream().collect(Collectors.toMap(WsComponents.Component::getId, Function.identity()));
        HashMap ancestors = new HashMap();
        for (WsComponents.Component c2 : modules) {
            ancestors.put(c2, modulesById.get(this.fetchAncestorId(c2.getId())));
        }
        HashMap<String, String> modulesWithPath = new HashMap<String, String>();
        modulesWithPath.put(moduleKey, "");
        modules.forEach(c -> modulesWithPath.put(c.getKey(), ModuleHierarchyDownloader.findPathFromRoot(c, ancestors)));
        return modulesWithPath;
    }

    private static String findPathFromRoot(WsComponents.Component component, Map<WsComponents.Component, WsComponents.Component> ancestors) {
        WsComponents.Component c = component;
        Path path = Paths.get("", new String[0]);
        do {
            path = Paths.get(c.getPath(), new String[0]).resolve(path);
        } while ((c = ancestors.get(c)) != null);
        return FileUtils.toSonarQubePath((String)path.toString());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @CheckForNull
    private String fetchAncestorId(String moduleId) {
        try (WsResponse response = this.wsClient.get("api/components/show.protobuf?id=" + StringUtils.urlEncode(moduleId));){
            InputStream stream = response.contentStream();
            WsComponents.ShowWsResponse showResponse = WsComponents.ShowWsResponse.parseFrom(stream);
            String string = showResponse.getAncestorsList().stream().map(WsComponents.Component::getId).findFirst().orElse(null);
            return string;
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to load module hierarchy", e);
        }
    }
}

