/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.container.analysis.issue.ignore.pattern;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import java.util.ArrayList;
import java.util.List;
import org.sonar.api.config.Configuration;
import org.sonarsource.sonarlint.core.container.analysis.ServerConfigurationProvider;
import org.sonarsource.sonarlint.core.container.analysis.issue.ignore.pattern.IssuePattern;

public abstract class AbstractPatternInitializer {
    private Configuration serverConfig;
    private List<IssuePattern> multicriteriaPatterns;

    protected AbstractPatternInitializer(ServerConfigurationProvider serverConfigProvider) {
        this.serverConfig = serverConfigProvider.getServerConfig();
        this.initPatterns();
    }

    public List<IssuePattern> getMulticriteriaPatterns() {
        return this.multicriteriaPatterns;
    }

    @VisibleForTesting
    protected final void initPatterns() {
        this.multicriteriaPatterns = new ArrayList<IssuePattern>();
        for (String id : this.serverConfig.getStringArray(this.getMulticriteriaConfigurationKey())) {
            String propPrefix = this.getMulticriteriaConfigurationKey() + "." + id + ".";
            String resourceKeyPattern = this.serverConfig.get(propPrefix + "resourceKey").orElse(null);
            String ruleKeyPattern = this.serverConfig.get(propPrefix + "ruleKey").orElse(null);
            IssuePattern pattern = new IssuePattern(MoreObjects.firstNonNull(resourceKeyPattern, "*"), MoreObjects.firstNonNull(ruleKeyPattern, "*"));
            this.multicriteriaPatterns.add(pattern);
        }
    }

    protected abstract String getMulticriteriaConfigurationKey();
}

