/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.container.analysis.issue.ignore;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.batch.fs.InputComponent;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.scan.issue.filter.FilterableIssue;
import org.sonar.api.scan.issue.filter.IssueFilter;
import org.sonar.api.scan.issue.filter.IssueFilterChain;
import org.sonarsource.sonarlint.core.analyzer.issue.DefaultFilterableIssue;
import org.sonarsource.sonarlint.core.container.analysis.issue.ignore.pattern.IssueExclusionPatternInitializer;
import org.sonarsource.sonarlint.core.container.analysis.issue.ignore.pattern.IssuePattern;

public class IgnoreIssuesFilter
implements IssueFilter {
    private static final Logger LOG = LoggerFactory.getLogger(IgnoreIssuesFilter.class);
    private final IssueExclusionPatternInitializer patternInitializer;

    public IgnoreIssuesFilter(IssueExclusionPatternInitializer patternInitializer) {
        this.patternInitializer = patternInitializer;
    }

    @Override
    public boolean accept(FilterableIssue issue, IssueFilterChain chain) {
        InputComponent inputComponent = ((DefaultFilterableIssue)issue).getInputComponent();
        for (IssuePattern pattern : this.patternInitializer.getMulticriteriaPatterns()) {
            if (!pattern.getRulePattern().match(issue.ruleKey().toString()) || !inputComponent.isFile() || !pattern.getPathPattern().match((InputFile)inputComponent)) continue;
            LOG.debug("Issue {} ignored by exclusion pattern {}", (Object)issue, (Object)pattern);
            return false;
        }
        return chain.accept(issue);
    }
}

