/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.container.analysis.filesystem;

import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.SetMultimap;
import java.nio.file.Path;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.sonar.api.batch.fs.InputDir;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.fs.internal.DefaultFileSystem;
import org.sonar.api.batch.fs.internal.FileExtensionPredicate;
import org.sonarsource.api.sonarlint.SonarLintSide;

@SonarLintSide
public class InputPathCache
extends DefaultFileSystem.Cache {
    private final Set<InputFile> inputFileCache = new LinkedHashSet<InputFile>();
    private final Map<Path, InputDir> inputDirCache = new LinkedHashMap<Path, InputDir>();
    private final SetMultimap<String, InputFile> filesByNameCache = LinkedHashMultimap.create();
    private final SetMultimap<String, InputFile> filesByExtensionCache = LinkedHashMultimap.create();
    private final SortedSet<String> languages = new TreeSet<String>();

    @Override
    public Iterable<InputFile> inputFiles() {
        return this.inputFileCache;
    }

    public Iterable<InputDir> allDirs() {
        return this.inputDirCache.values();
    }

    @Override
    public void doAdd(InputFile inputFile) {
        if (inputFile.language() != null) {
            this.languages.add(inputFile.language());
        }
        this.inputFileCache.add(inputFile);
        this.filesByNameCache.put(inputFile.filename(), inputFile);
        this.filesByExtensionCache.put(FileExtensionPredicate.getExtension(inputFile), inputFile);
    }

    @Override
    public void doAdd(InputDir inputDir) {
        this.inputDirCache.put(inputDir.path(), inputDir);
    }

    @Override
    public InputFile inputFile(String relativePath) {
        return null;
    }

    @Override
    public InputDir inputDir(String relativePath) {
        return null;
    }

    public InputDir inputDir(Path path) {
        return this.inputDirCache.get(path);
    }

    @Override
    public Iterable<InputFile> getFilesByName(String filename) {
        return this.filesByNameCache.get(filename);
    }

    @Override
    public Iterable<InputFile> getFilesByExtension(String extension) {
        return this.filesByExtensionCache.get(extension);
    }

    @Override
    protected SortedSet<String> languages() {
        return this.languages;
    }
}

