/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.container.analysis.filesystem;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import javax.annotation.CheckForNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.batch.fs.InputFile;
import org.sonarsource.sonarlint.core.client.api.common.analysis.ClientInputFile;
import org.sonarsource.sonarlint.core.container.analysis.filesystem.FileMetadata;
import org.sonarsource.sonarlint.core.container.analysis.filesystem.LanguageDetection;
import org.sonarsource.sonarlint.core.container.analysis.filesystem.SonarLintInputFile;

public class InputFileBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(InputFileBuilder.class);
    private final LanguageDetection langDetection;
    private final FileMetadata fileMetadata;

    public InputFileBuilder(LanguageDetection langDetection, FileMetadata fileMetadata) {
        this.langDetection = langDetection;
        this.fileMetadata = fileMetadata;
    }

    LanguageDetection langDetection() {
        return this.langDetection;
    }

    @CheckForNull
    SonarLintInputFile create(ClientInputFile inputFile) {
        InputStream stream;
        SonarLintInputFile defaultInputFile = new SonarLintInputFile(inputFile);
        defaultInputFile.setType(inputFile.isTest() ? InputFile.Type.TEST : InputFile.Type.MAIN);
        if (inputFile.language() != null) {
            LOG.debug("Language of file '{}' is set to '{}'", (Object)inputFile.uri(), (Object)inputFile.language());
            defaultInputFile.setLanguage(inputFile.language());
        } else {
            defaultInputFile.setLanguage(this.langDetection.language(defaultInputFile));
        }
        Charset charset = inputFile.getCharset();
        try {
            stream = inputFile.inputStream();
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to open a stream on file: " + inputFile.getPath(), e);
        }
        defaultInputFile.init(this.fileMetadata.readMetadata(stream, charset != null ? charset : Charset.defaultCharset(), inputFile.getPath()));
        return defaultInputFile;
    }
}

