/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.container.analysis.filesystem;

import com.google.common.primitives.Ints;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.ByteOrderMark;
import org.apache.commons.io.input.BOMInputStream;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonarsource.api.sonarlint.SonarLintSide;

@SonarLintSide
public class FileMetadata {
    private static final Logger LOG = Loggers.get(FileMetadata.class);
    private static final char LINE_FEED = '\n';
    private static final char CARRIAGE_RETURN = '\r';

    public Metadata readMetadata(File file, Charset encoding) {
        InputStream stream = FileMetadata.streamFile(file);
        return this.readMetadata(stream, encoding, file.getAbsolutePath());
    }

    public Metadata readMetadata(InputStream stream, Charset encoding, String filePath) {
        LineCounter lineCounter = new LineCounter(filePath, encoding);
        LineOffsetCounter lineOffsetCounter = new LineOffsetCounter();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(stream, encoding));){
            FileMetadata.read(reader, lineCounter, lineOffsetCounter);
        }
        catch (IOException e) {
            throw new IllegalStateException(String.format("Fail to read file '%s' with encoding '%s'", filePath, encoding), e);
        }
        return new Metadata(lineCounter.lines(), lineOffsetCounter.getOriginalLineOffsets(), lineOffsetCounter.getLastValidOffset());
    }

    private static InputStream streamFile(File file) {
        try {
            return new BOMInputStream((InputStream)new FileInputStream(file), ByteOrderMark.UTF_8, ByteOrderMark.UTF_16LE, ByteOrderMark.UTF_16BE, ByteOrderMark.UTF_32LE, ByteOrderMark.UTF_32BE);
        }
        catch (FileNotFoundException e) {
            throw new IllegalStateException("File not found: " + file.getAbsolutePath(), e);
        }
    }

    private static void read(Reader reader, CharHandler ... handlers) throws IOException {
        int i = reader.read();
        boolean afterCR = false;
        while (i != -1) {
            char c = (char)i;
            if (afterCR) {
                for (CharHandler handler : handlers) {
                    if (c == '\r') {
                        handler.newLine();
                        handler.handleAll(c);
                        continue;
                    }
                    if (c == '\n') {
                        handler.handleAll(c);
                        handler.newLine();
                        continue;
                    }
                    handler.newLine();
                    handler.handleIgnoreEoL(c);
                    handler.handleAll(c);
                }
                afterCR = c == '\r';
            } else if (c == '\n') {
                for (CharHandler handler : handlers) {
                    handler.handleAll(c);
                    handler.newLine();
                }
            } else if (c == '\r') {
                afterCR = true;
                for (CharHandler handler : handlers) {
                    handler.handleAll(c);
                }
            } else {
                for (CharHandler handler : handlers) {
                    handler.handleIgnoreEoL(c);
                    handler.handleAll(c);
                }
            }
            i = reader.read();
        }
        for (CharHandler handler : handlers) {
            if (afterCR) {
                handler.newLine();
            }
            handler.eof();
        }
    }

    public static class Metadata {
        final int lines;
        final int[] originalLineOffsets;
        final int lastValidOffset;

        private Metadata(int lines, List<Integer> originalLineOffsets, int lastValidOffset) {
            this.lines = lines;
            this.originalLineOffsets = Ints.toArray(originalLineOffsets);
            this.lastValidOffset = lastValidOffset;
        }
    }

    private static class LineOffsetCounter
    extends CharHandler {
        private int currentOriginalOffset = 0;
        private List<Integer> originalLineOffsets = new ArrayList<Integer>();
        private int lastValidOffset = 0;

        public LineOffsetCounter() {
            this.originalLineOffsets.add(0);
        }

        @Override
        protected void handleAll(char c) {
            ++this.currentOriginalOffset;
        }

        @Override
        protected void newLine() {
            this.originalLineOffsets.add(this.currentOriginalOffset);
        }

        @Override
        protected void eof() {
            this.lastValidOffset = this.currentOriginalOffset;
        }

        public List<Integer> getOriginalLineOffsets() {
            return this.originalLineOffsets;
        }

        public int getLastValidOffset() {
            return this.lastValidOffset;
        }
    }

    private static class LineCounter
    extends CharHandler {
        private int lines = 1;
        boolean alreadyLoggedInvalidCharacter = false;
        private final String filePath;
        private final Charset encoding;

        LineCounter(String filePath, Charset encoding) {
            this.filePath = filePath;
            this.encoding = encoding;
        }

        @Override
        protected void handleAll(char c) {
            if (!this.alreadyLoggedInvalidCharacter && c == '\ufffd') {
                LOG.warn("Invalid character encountered in file '{}' at line {} for encoding {}. Please fix file content or configure the encoding to be used using property '{}'.", this.filePath, this.lines, this.encoding, "sonar.sourceEncoding");
                this.alreadyLoggedInvalidCharacter = true;
            }
        }

        @Override
        protected void newLine() {
            ++this.lines;
        }

        public int lines() {
            return this.lines;
        }
    }

    public static abstract class CharHandler {
        protected void handleAll(char c) {
        }

        protected void handleIgnoreEoL(char c) {
        }

        protected void newLine() {
        }

        protected void eof() {
        }
    }
}

