/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.container.analysis.filesystem;

import java.nio.file.Path;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.utils.MessageException;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonarsource.api.sonarlint.SonarLintSide;
import org.sonarsource.sonarlint.core.client.api.common.analysis.ClientInputFile;
import org.sonarsource.sonarlint.core.client.api.standalone.StandaloneAnalysisConfiguration;
import org.sonarsource.sonarlint.core.container.analysis.ExclusionFilters;
import org.sonarsource.sonarlint.core.container.analysis.filesystem.InputFileBuilder;
import org.sonarsource.sonarlint.core.container.analysis.filesystem.SonarLintFileSystem;
import org.sonarsource.sonarlint.core.container.analysis.filesystem.SonarLintInputDir;
import org.sonarsource.sonarlint.core.container.analysis.filesystem.SonarLintInputFile;
import org.sonarsource.sonarlint.core.container.model.DefaultAnalysisResult;
import org.sonarsource.sonarlint.core.util.ProgressReport;

@SonarLintSide
public class FileIndexer {
    private static final Logger LOG = Loggers.get(FileIndexer.class);
    private final InputFileBuilder inputFileBuilder;
    private final StandaloneAnalysisConfiguration analysisConfiguration;
    private final DefaultAnalysisResult analysisResult;
    private final ExclusionFilters exclusionFilters;
    private ProgressReport progressReport;

    public FileIndexer(InputFileBuilder inputFileBuilder, ExclusionFilters exclusionFilters, StandaloneAnalysisConfiguration analysisConfiguration, DefaultAnalysisResult analysisResult) {
        this.inputFileBuilder = inputFileBuilder;
        this.exclusionFilters = exclusionFilters;
        this.analysisConfiguration = analysisConfiguration;
        this.analysisResult = analysisResult;
    }

    void index(SonarLintFileSystem fileSystem) {
        this.progressReport = new ProgressReport("Report about progress of file indexation", TimeUnit.SECONDS.toMillis(10L));
        this.progressReport.start("Index files");
        this.exclusionFilters.prepare();
        Progress progress = new Progress();
        try {
            this.indexFiles(fileSystem, progress, this.analysisConfiguration.inputFiles());
        }
        catch (Exception e) {
            this.progressReport.stop(null);
            throw e;
        }
        this.progressReport.stop(progress.count() + " files indexed");
        this.analysisResult.setFileCount(progress.count());
    }

    private void indexFiles(SonarLintFileSystem fileSystem, Progress progress, Iterable<ClientInputFile> inputFiles) {
        for (ClientInputFile file : inputFiles) {
            this.indexFile(fileSystem, progress, file);
        }
    }

    private void indexFile(SonarLintFileSystem fileSystem, Progress progress, ClientInputFile file) {
        SonarLintInputFile inputFile = this.inputFileBuilder.create(file);
        if (this.exclusionFilters.accept(inputFile, file.isTest() ? InputFile.Type.TEST : InputFile.Type.MAIN)) {
            this.indexFile(fileSystem, progress, inputFile);
        } else {
            LOG.debug("{} ignored because of inclusion/exclusion patterns", (Object)file.uri());
        }
    }

    private void indexFile(SonarLintFileSystem fs, Progress status, SonarLintInputFile inputFile) {
        fs.add(inputFile);
        if (status.count() == 0) {
            LOG.debug("Setting filesystem encoding: " + inputFile.charset());
            fs.setEncoding(inputFile.charset());
        }
        status.markAsIndexed(inputFile);
        SonarLintInputDir inputDir = new SonarLintInputDir(inputFile.path().getParent());
        fs.add(inputDir);
    }

    private class Progress {
        private final Set<Path> indexed = new HashSet<Path>();

        private Progress() {
        }

        synchronized void markAsIndexed(SonarLintInputFile inputFile) {
            if (this.indexed.contains(inputFile.path())) {
                throw MessageException.of("File " + inputFile + " can't be indexed twice.");
            }
            this.indexed.add(inputFile.path());
            FileIndexer.this.progressReport.message(this.indexed.size() + " files indexed...  (last one was " + inputFile.absolutePath() + ")");
        }

        int count() {
            return this.indexed.size();
        }
    }
}

