/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.container.analysis.filesystem;

import java.util.ArrayList;
import java.util.Collection;
import javax.annotation.CheckForNull;
import org.picocontainer.Startable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.resources.Languages;
import org.sonarsource.sonarlint.core.container.analysis.filesystem.Language;
import org.sonarsource.sonarlint.core.container.analysis.filesystem.LanguagesRepository;

public class DefaultLanguagesRepository
implements LanguagesRepository,
Startable {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultLanguagesRepository.class);
    private Languages languages;

    public DefaultLanguagesRepository(Languages languages) {
        this.languages = languages;
    }

    @Override
    public void start() {
        if (this.languages.all().length == 0) {
            LOG.warn("No analyzers installed");
        }
    }

    @Override
    @CheckForNull
    public Language get(String languageKey) {
        org.sonar.api.resources.Language language = this.languages.get(languageKey);
        return language != null ? new Language(language.getKey(), language.getName(), language.getFileSuffixes()) : null;
    }

    @Override
    public Collection<Language> all() {
        org.sonar.api.resources.Language[] all = this.languages.all();
        ArrayList<Language> result = new ArrayList<Language>(all.length);
        for (org.sonar.api.resources.Language language : all) {
            result.add(new Language(language.getKey(), language.getName(), language.getFileSuffixes()));
        }
        return result;
    }

    @Override
    public void stop() {
    }
}

