/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.container.analysis;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.sonar.api.config.PropertyDefinitions;
import org.sonar.api.config.internal.MapSettings;
import org.sonarsource.sonarlint.core.client.api.connected.ConnectedAnalysisConfiguration;
import org.sonarsource.sonarlint.core.client.api.standalone.StandaloneAnalysisConfiguration;
import org.sonarsource.sonarlint.core.container.storage.StorageReader;
import org.sonarsource.sonarlint.core.proto.Sonarlint;

public class MutableAnalysisSettings
extends MapSettings {
    private static final String C_SUFFIXES_KEY = "sonar.c.file.suffixes";
    private static final String CPP_SUFFIXES_KEY = "sonar.cpp.file.suffixes";
    private static final String OBJC_SUFFIXES_KEY = "sonar.objc.file.suffixes";
    private static final String DISABLED_SUFFIX = "disabled";
    private final Map<String, String> properties = new HashMap<String, String>();

    public MutableAnalysisSettings(StandaloneAnalysisConfiguration config, PropertyDefinitions propertyDefinitions) {
        super(propertyDefinitions);
        this.addDefaultProperties();
        this.addProperties(config.extraProperties());
    }

    public MutableAnalysisSettings(StorageReader storage, StandaloneAnalysisConfiguration config, PropertyDefinitions propertyDefinitions) {
        super(propertyDefinitions);
        Sonarlint.GlobalProperties globalProps = storage.readGlobalProperties();
        this.addProperties(globalProps.getPropertiesMap());
        if (config instanceof ConnectedAnalysisConfiguration && ((ConnectedAnalysisConfiguration)config).moduleKey() != null) {
            Sonarlint.ModuleConfiguration projectConfig = storage.readModuleConfig(((ConnectedAnalysisConfiguration)config).moduleKey());
            this.addProperties(projectConfig.getPropertiesMap());
        }
        this.addDefaultProperties();
        this.addProperties(config.extraProperties());
    }

    private void addDefaultProperties() {
        this.setProperty(C_SUFFIXES_KEY, DISABLED_SUFFIX);
        this.setProperty(CPP_SUFFIXES_KEY, DISABLED_SUFFIX);
        this.setProperty(OBJC_SUFFIXES_KEY, DISABLED_SUFFIX);
    }

    @Override
    protected Optional<String> get(String key) {
        return Optional.ofNullable(this.properties.get(key));
    }

    @Override
    protected void set(String key, String value) {
        this.properties.put(key, value);
    }

    @Override
    protected void remove(String key) {
        this.properties.remove(key);
    }

    @Override
    public Map<String, String> getProperties() {
        return this.properties;
    }
}

