/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.analyzer.sensor;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.commons.lang.ClassUtils;
import org.sonar.api.batch.CheckProject;
import org.sonar.api.batch.DependedUpon;
import org.sonar.api.batch.DependsUpon;
import org.sonar.api.batch.Phase;
import org.sonar.api.batch.sensor.Sensor;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.resources.Project;
import org.sonar.api.utils.AnnotationUtils;
import org.sonar.api.utils.dag.DirectAcyclicGraph;
import org.sonarsource.sonarlint.core.analyzer.sensor.DefaultSensorContext;
import org.sonarsource.sonarlint.core.analyzer.sensor.SensorOptimizer;
import org.sonarsource.sonarlint.core.analyzer.sensor.SensorWrapper;
import org.sonarsource.sonarlint.core.container.ComponentContainer;

public class ScannerExtensionDictionnary {
    private final ComponentContainer componentContainer;
    private final SensorContext sensorContext;
    private final SensorOptimizer sensorOptimizer;

    public ScannerExtensionDictionnary(ComponentContainer componentContainer, DefaultSensorContext sensorContext, SensorOptimizer sensorOptimizer) {
        this.componentContainer = componentContainer;
        this.sensorContext = sensorContext;
        this.sensorOptimizer = sensorOptimizer;
    }

    public <T> Collection<T> select(Class<T> type, @Nullable Project project, boolean sort) {
        List<T> result = this.getFilteredExtensions(type, project);
        if (sort) {
            return ScannerExtensionDictionnary.sort(result);
        }
        return result;
    }

    private static Phase.Name evaluatePhase(Object extension) {
        Object extensionToEvaluate = extension instanceof SensorWrapper ? ((SensorWrapper)extension).wrappedSensor() : extension;
        Phase phaseAnnotation = AnnotationUtils.getAnnotation(extensionToEvaluate, Phase.class);
        if (phaseAnnotation != null) {
            return phaseAnnotation.name();
        }
        return Phase.Name.DEFAULT;
    }

    private <T> List<T> getFilteredExtensions(Class<T> type, @Nullable Project project) {
        ArrayList<Object> result = new ArrayList<Object>();
        for (Object extension : this.getExtensions(type)) {
            if (org.sonar.api.batch.Sensor.class.equals(type) && extension instanceof Sensor) {
                extension = new SensorWrapper((Sensor)extension, this.sensorContext, this.sensorOptimizer);
            }
            if (!ScannerExtensionDictionnary.shouldKeep(type, extension, project)) continue;
            result.add(extension);
        }
        if (org.sonar.api.batch.Sensor.class.equals(type)) {
            for (Object extension : this.getExtensions(Sensor.class)) {
                if (!ScannerExtensionDictionnary.shouldKeep(type, extension = new SensorWrapper((Sensor)extension, this.sensorContext, this.sensorOptimizer), project)) continue;
                result.add(extension);
            }
        }
        return result;
    }

    protected List<Object> getExtensions(Class type) {
        ArrayList<Object> extensions = new ArrayList<Object>();
        ScannerExtensionDictionnary.completeBatchExtensions(this.componentContainer, extensions, type);
        return extensions;
    }

    private static void completeBatchExtensions(@Nullable ComponentContainer container, List<Object> extensions, Class type) {
        if (container != null) {
            extensions.addAll(container.getComponentsByType(type));
            ScannerExtensionDictionnary.completeBatchExtensions(container.getParent(), extensions, type);
        }
    }

    public static <T> Collection<T> sort(Collection<T> extensions) {
        DirectAcyclicGraph dag = new DirectAcyclicGraph(new Object[0]);
        for (T extension : extensions) {
            dag.add(extension, new Object[0]);
            for (Object dependency : ScannerExtensionDictionnary.getDependencies(extension)) {
                dag.add(extension, dependency);
            }
            for (Object generates : ScannerExtensionDictionnary.getDependents(extension)) {
                dag.add(generates, extension);
            }
            ScannerExtensionDictionnary.completePhaseDependencies(dag, extension);
        }
        List sortedList = dag.sort();
        return sortedList.stream().filter(extensions::contains).collect(Collectors.toList());
    }

    private static <T> List<Object> getDependencies(T extension) {
        ArrayList<Object> result = new ArrayList<Object>();
        result.addAll(ScannerExtensionDictionnary.evaluateAnnotatedClasses(extension, DependsUpon.class));
        return result;
    }

    public static <T> List<Object> getDependents(T extension) {
        ArrayList<Object> result = new ArrayList<Object>();
        result.addAll(ScannerExtensionDictionnary.evaluateAnnotatedClasses(extension, DependedUpon.class));
        return result;
    }

    private static void completePhaseDependencies(DirectAcyclicGraph dag, Object extension) {
        Phase.Name phase = ScannerExtensionDictionnary.evaluatePhase(extension);
        dag.add(extension, new Object[]{phase});
        for (Phase.Name name : Phase.Name.values()) {
            if (phase.compareTo(name) < 0) {
                dag.add((Object)name, extension);
                continue;
            }
            if (phase.compareTo(name) <= 0) continue;
            dag.add(extension, new Object[]{name});
        }
    }

    protected static List<Object> evaluateAnnotatedClasses(Object extension, Class<? extends Annotation> annotation) {
        ArrayList<Object> results = new ArrayList<Object>();
        for (Class<?> aClass = extension.getClass(); aClass != null; aClass = aClass.getSuperclass()) {
            ScannerExtensionDictionnary.evaluateClass(aClass, annotation, results);
        }
        return results;
    }

    private static void evaluateClass(Class extensionClass, Class annotationClass, List<Object> results) {
        Class<?>[] interfaces;
        Object annotation = extensionClass.getAnnotation(annotationClass);
        if (annotation != null) {
            if (annotation.annotationType().isAssignableFrom(DependsUpon.class)) {
                results.addAll(Arrays.asList(((DependsUpon)annotation).value()));
            } else if (annotation.annotationType().isAssignableFrom(DependedUpon.class)) {
                results.addAll(Arrays.asList(((DependedUpon)annotation).value()));
            }
        }
        for (Class<?> anInterface : interfaces = extensionClass.getInterfaces()) {
            ScannerExtensionDictionnary.evaluateClass(anInterface, annotationClass, results);
        }
    }

    private static boolean shouldKeep(Class type, Object extension, @Nullable Project project) {
        boolean keep;
        boolean bl = keep = ClassUtils.isAssignable(extension.getClass(), type) || org.sonar.api.batch.Sensor.class.equals((Object)type) && ClassUtils.isAssignable(extension.getClass(), Sensor.class);
        if (keep && project != null && ClassUtils.isAssignable(extension.getClass(), CheckProject.class)) {
            keep = ((CheckProject)extension).shouldExecuteOnProject(project);
        }
        return keep;
    }
}

