/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.analyzer.sensor;

import com.google.common.base.Strings;
import java.util.Map;
import java.util.Set;
import org.sonar.api.batch.fs.InputComponent;
import org.sonar.api.batch.fs.TextRange;
import org.sonar.api.batch.fs.internal.DefaultInputFile;
import org.sonar.api.batch.rule.ActiveRule;
import org.sonar.api.batch.rule.ActiveRules;
import org.sonar.api.batch.rule.Rule;
import org.sonar.api.batch.rule.Rules;
import org.sonar.api.batch.rule.Severity;
import org.sonar.api.batch.rule.internal.DefaultRule;
import org.sonar.api.batch.sensor.coverage.internal.DefaultCoverage;
import org.sonar.api.batch.sensor.cpd.internal.DefaultCpdTokens;
import org.sonar.api.batch.sensor.error.AnalysisError;
import org.sonar.api.batch.sensor.highlighting.internal.DefaultHighlighting;
import org.sonar.api.batch.sensor.internal.SensorStorage;
import org.sonar.api.batch.sensor.issue.Issue;
import org.sonar.api.batch.sensor.measure.Measure;
import org.sonar.api.batch.sensor.symbol.internal.DefaultSymbolTable;
import org.sonar.api.rule.RuleKey;
import org.sonar.api.source.Symbol;
import org.sonar.api.utils.MessageException;
import org.sonarsource.sonarlint.core.analyzer.issue.DefaultClientIssue;
import org.sonarsource.sonarlint.core.analyzer.issue.IssueFilters;
import org.sonarsource.sonarlint.core.client.api.common.analysis.ClientInputFile;
import org.sonarsource.sonarlint.core.client.api.common.analysis.IssueListener;
import org.sonarsource.sonarlint.core.container.analysis.filesystem.SonarLintInputFile;
import org.sonarsource.sonarlint.core.container.model.DefaultAnalysisResult;

public class DefaultSensorStorage
implements SensorStorage {
    private final ActiveRules activeRules;
    private final Rules rules;
    private final IssueFilters filters;
    private final IssueListener issueListener;
    private final DefaultAnalysisResult analysisResult;

    public DefaultSensorStorage(ActiveRules activeRules, Rules rules, IssueFilters filters, IssueListener issueListener, DefaultAnalysisResult analysisResult) {
        this.activeRules = activeRules;
        this.rules = rules;
        this.filters = filters;
        this.issueListener = issueListener;
        this.analysisResult = analysisResult;
    }

    @Override
    public void store(Measure newMeasure) {
    }

    @Override
    public void store(Issue issue) {
        String type;
        InputComponent inputComponent = issue.primaryLocation().inputComponent();
        DefaultRule rule = this.validateRule(issue);
        ActiveRule activeRule = this.activeRules.find(issue.ruleKey());
        if (activeRule == null) {
            return;
        }
        String primaryMessage = Strings.isNullOrEmpty(issue.primaryLocation().message()) ? rule.name() : issue.primaryLocation().message();
        Severity overriddenSeverity = issue.overriddenSeverity();
        String severity = overriddenSeverity != null ? overriddenSeverity.name() : activeRule.severity();
        DefaultClientIssue newIssue = new DefaultClientIssue(severity, type = rule.type(), activeRule, this.rules.find(activeRule.ruleKey()), primaryMessage, issue.primaryLocation().textRange(), inputComponent.isFile() ? ((SonarLintInputFile)inputComponent).getClientInputFile() : null, issue.flows());
        if (this.filters.accept(inputComponent, newIssue)) {
            this.issueListener.handle((org.sonarsource.sonarlint.core.client.api.common.analysis.Issue)newIssue);
        }
    }

    private DefaultRule validateRule(Issue issue) {
        RuleKey ruleKey = issue.ruleKey();
        Rule rule = this.rules.find(ruleKey);
        if (rule == null) {
            throw MessageException.of(String.format("The rule '%s' does not exist.", ruleKey));
        }
        if (Strings.isNullOrEmpty(rule.name()) && Strings.isNullOrEmpty(issue.primaryLocation().message())) {
            throw MessageException.of(String.format("The rule '%s' has no name and the related issue has no message.", ruleKey));
        }
        return (DefaultRule)rule;
    }

    @Override
    public void store(DefaultHighlighting highlighting) {
    }

    public void store(DefaultInputFile inputFile, Map<Symbol, Set<TextRange>> referencesBySymbol) {
    }

    @Override
    public void store(DefaultCoverage defaultCoverage) {
    }

    @Override
    public void store(DefaultCpdTokens defaultCpdTokens) {
    }

    @Override
    public void store(DefaultSymbolTable symbolTable) {
    }

    @Override
    public void store(AnalysisError analysisError) {
        ClientInputFile clientInputFile = ((SonarLintInputFile)analysisError.inputFile()).getClientInputFile();
        this.analysisResult.addFailedAnalysisFile(clientInputFile);
    }

    @Override
    public void storeProperty(String key, String value) {
    }
}

