/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.analyzer.sensor;

import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.batch.Sensor;
import org.sonar.api.batch.SensorContext;
import org.sonar.api.batch.events.SensorsPhaseHandler;
import org.sonar.api.resources.Project;
import org.sonarsource.sonarlint.core.analyzer.sensor.DefaultSensorsPhaseEvent;
import org.sonarsource.sonarlint.core.analyzer.sensor.ScannerExtensionDictionnary;
import org.sonarsource.sonarlint.core.analyzer.sensor.SensorsExecutor;
import org.sonarsource.sonarlint.core.util.ProgressWrapper;
import org.sonarsource.sonarlint.core.util.StringUtils;

public class AllSensorsExecutor
implements SensorsExecutor {
    private static final Logger LOG = LoggerFactory.getLogger(AllSensorsExecutor.class);
    private final Project module;
    private final ScannerExtensionDictionnary selector;
    private final SensorsPhaseHandler[] handlers;
    private final ProgressWrapper progress;
    private final SensorContext context;

    public AllSensorsExecutor(SensorContext context, ScannerExtensionDictionnary selector, Project project, ProgressWrapper progress) {
        this(context, selector, project, progress, new SensorsPhaseHandler[0]);
    }

    public AllSensorsExecutor(SensorContext context, ScannerExtensionDictionnary selector, Project project, ProgressWrapper progress, SensorsPhaseHandler[] handlers) {
        this.context = context;
        this.selector = selector;
        this.module = project;
        this.progress = progress;
        this.handlers = handlers;
    }

    @Override
    public void execute() {
        Collection<Sensor> sensors = this.selector.select(Sensor.class, this.module, true);
        for (SensorsPhaseHandler sensorsPhaseHandler : this.handlers) {
            sensorsPhaseHandler.onSensorsPhase(new DefaultSensorsPhaseEvent(sensors, true));
        }
        for (Sensor sensor : sensors) {
            this.progress.checkCancel();
            this.executeSensor(this.context, sensor);
        }
        for (SensorsPhaseHandler sensorsPhaseHandler : this.handlers) {
            sensorsPhaseHandler.onSensorsPhase(new DefaultSensorsPhaseEvent(sensors, false));
        }
    }

    private void executeSensor(SensorContext context, Sensor sensor) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Execute Sensor: {}", (Object)StringUtils.describe(sensor));
        }
        sensor.analyse(this.module, context);
    }
}

