/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.analyzer.issue;

import com.google.common.base.Preconditions;
import javax.annotation.Nullable;
import org.sonar.api.batch.fs.InputComponent;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.fs.TextRange;
import org.sonar.api.batch.rule.Severity;
import org.sonar.api.batch.sensor.issue.NewIssueLocation;
import org.sonar.api.batch.sensor.issue.internal.DefaultIssue;
import org.sonar.api.batch.sensor.issue.internal.DefaultIssueLocation;
import org.sonar.api.issue.Issuable;
import org.sonar.api.issue.Issue;
import org.sonar.api.rule.RuleKey;
import org.sonarsource.sonarlint.core.analyzer.issue.DeprecatedIssueWrapper;

public class DeprecatedIssueBuilderWrapper
implements Issuable.IssueBuilder {
    private final DefaultIssue newIssue;
    private final InputComponent primaryComponent;
    private TextRange primaryRange = null;
    private String primaryMessage = null;

    public DeprecatedIssueBuilderWrapper(InputComponent primaryComponent, DefaultIssue newIssue) {
        this.primaryComponent = primaryComponent;
        this.newIssue = newIssue;
    }

    @Override
    public Issuable.IssueBuilder ruleKey(RuleKey ruleKey) {
        this.newIssue.forRule(ruleKey);
        return this;
    }

    @Override
    public Issuable.IssueBuilder line(@Nullable Integer line) {
        Preconditions.checkState(this.newIssue.primaryLocation() == null, "Do not use line() and at() for the same issue");
        if (this.primaryComponent.isFile()) {
            if (line != null) {
                this.primaryRange = ((InputFile)this.primaryComponent).selectLine(line);
            }
            return this;
        }
        throw new IllegalArgumentException("Unable to set line for issues on project or directory");
    }

    @Override
    public Issuable.IssueBuilder message(String message) {
        Preconditions.checkState(this.newIssue.primaryLocation() == null, "Do not use message() and at() for the same issue");
        this.primaryMessage = message;
        return this;
    }

    @Override
    public NewIssueLocation newLocation() {
        return new DefaultIssueLocation();
    }

    @Override
    public Issuable.IssueBuilder at(NewIssueLocation primaryLocation) {
        Preconditions.checkState(this.primaryMessage == null && this.primaryRange == null, "Do not use message() or line() and at() for the same issue");
        this.newIssue.at(primaryLocation);
        return this;
    }

    @Override
    public Issuable.IssueBuilder addLocation(NewIssueLocation secondaryLocation) {
        this.newIssue.addLocation(secondaryLocation);
        return this;
    }

    @Override
    public Issuable.IssueBuilder addFlow(Iterable<NewIssueLocation> flowLocations) {
        this.newIssue.addFlow((Iterable)flowLocations);
        return this;
    }

    @Override
    public Issuable.IssueBuilder severity(String severity) {
        this.newIssue.overrideSeverity(Severity.valueOf(severity));
        return this;
    }

    @Override
    public Issuable.IssueBuilder reporter(String reporter) {
        throw new UnsupportedOperationException("Not supported during sensor phase");
    }

    @Override
    public Issuable.IssueBuilder effortToFix(Double d) {
        this.newIssue.effortToFix(d);
        return this;
    }

    @Override
    public Issuable.IssueBuilder attribute(String key, String value) {
        throw new UnsupportedOperationException("Not supported during sensor phase");
    }

    @Override
    public Issue build() {
        if (this.newIssue.primaryLocation() == null) {
            NewIssueLocation newLocation = this.newIssue.newLocation().on(this.primaryComponent);
            if (this.primaryMessage != null) {
                newLocation.message(this.primaryMessage);
            }
            if (this.primaryComponent.isFile() && this.primaryRange != null) {
                newLocation.at(this.primaryRange);
            }
            this.newIssue.at(newLocation);
        }
        return new DeprecatedIssueWrapper(this.newIssue);
    }
}

