/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.analyzer.issue;

import java.util.Date;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.sonar.api.batch.fs.InputComponent;
import org.sonar.api.resources.Project;
import org.sonar.api.rule.RuleKey;
import org.sonar.api.scan.issue.filter.FilterableIssue;
import org.sonarsource.sonarlint.core.analyzer.issue.DefaultClientIssue;

public class DefaultFilterableIssue
implements FilterableIssue {
    private final DefaultClientIssue rawIssue;
    private final Project project;
    private final InputComponent inputComponent;

    public DefaultFilterableIssue(Project project, DefaultClientIssue rawIssue, InputComponent inputComponent) {
        this.project = project;
        this.rawIssue = rawIssue;
        this.inputComponent = inputComponent;
    }

    @Override
    public String componentKey() {
        return this.inputComponent.key();
    }

    @Override
    public RuleKey ruleKey() {
        return RuleKey.parse(this.rawIssue.getRuleKey());
    }

    @Override
    public String severity() {
        throw DefaultFilterableIssue.unsupported();
    }

    @Override
    public String message() {
        throw DefaultFilterableIssue.unsupported();
    }

    @Override
    public Integer line() {
        return this.rawIssue.getStartLine();
    }

    @Override
    public Double effortToFix() {
        throw DefaultFilterableIssue.unsupported();
    }

    @Override
    public Date creationDate() {
        return new Date();
    }

    @Override
    public String projectKey() {
        return this.project.getEffectiveKey();
    }

    public String toString() {
        return ToStringBuilder.reflectionToString(this, ToStringStyle.SHORT_PREFIX_STYLE);
    }

    private static UnsupportedOperationException unsupported() {
        return new UnsupportedOperationException("Not available for issues filters");
    }

    @Override
    public Double gap() {
        throw DefaultFilterableIssue.unsupported();
    }

    public InputComponent getInputComponent() {
        return this.inputComponent;
    }
}

