/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.analyzer.issue;

import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.api.batch.fs.TextRange;
import org.sonar.api.batch.rule.ActiveRule;
import org.sonar.api.batch.rule.Rule;
import org.sonar.api.batch.sensor.issue.Issue;
import org.sonar.api.batch.sensor.issue.IssueLocation;
import org.sonarsource.sonarlint.core.analyzer.issue.TextRangeLocation;
import org.sonarsource.sonarlint.core.client.api.common.analysis.ClientInputFile;
import org.sonarsource.sonarlint.core.client.api.common.analysis.Issue;

public final class DefaultClientIssue
extends TextRangeLocation
implements Issue {
    private final String severity;
    private final String type;
    private final ActiveRule activeRule;
    private final String primaryMessage;
    private final ClientInputFile clientInputFile;
    private final Rule rule;
    private final List<Issue.Flow> flows;

    public DefaultClientIssue(String severity, @Nullable String type, ActiveRule activeRule, Rule rule, String primaryMessage, @Nullable TextRange textRange, @Nullable ClientInputFile clientInputFile, List<Issue.Flow> flows) {
        super(textRange);
        this.severity = severity;
        this.type = type;
        this.activeRule = activeRule;
        this.rule = rule;
        this.primaryMessage = primaryMessage;
        this.clientInputFile = clientInputFile;
        this.flows = flows.stream().map(f -> new DefaultFlow(f.locations())).collect(Collectors.toList());
    }

    public String getSeverity() {
        return this.severity;
    }

    public String getType() {
        return this.type;
    }

    public String getRuleName() {
        return this.rule.name();
    }

    public String getRuleKey() {
        return this.activeRule.ruleKey().toString();
    }

    public String getMessage() {
        return this.primaryMessage;
    }

    @CheckForNull
    public ClientInputFile getInputFile() {
        return this.clientInputFile;
    }

    public List<Issue.Flow> flows() {
        return this.flows;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        sb.append("rule=").append(this.activeRule.ruleKey());
        sb.append(", severity=").append(this.severity);
        if (this.textRange != null) {
            sb.append(", line=").append(this.textRange.start().line());
        }
        if (this.clientInputFile != null) {
            sb.append(", file=").append(this.clientInputFile.getPath());
        }
        sb.append("]");
        return sb.toString();
    }

    private static class DefaultFlow
    implements Issue.Flow {
        private List<org.sonarsource.sonarlint.core.client.api.common.analysis.IssueLocation> locations;

        private DefaultFlow(List<IssueLocation> issueLocations) {
            this.locations = issueLocations.stream().map(i -> new DefaultLocation(i.textRange(), i.message())).collect(Collectors.toList());
        }

        public List<org.sonarsource.sonarlint.core.client.api.common.analysis.IssueLocation> locations() {
            return this.locations;
        }
    }

    private static class DefaultLocation
    extends TextRangeLocation {
        private final String message;

        private DefaultLocation(@Nullable TextRange textRange, @Nullable String message) {
            super(textRange);
            this.message = message;
        }

        public String getMessage() {
            return this.message;
        }
    }
}

